package org.jboss.webbeans.tck.integration.context.passivating;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson 
 * 
 * Spec version: PRD2
 */
public class PassivatingContextTest extends AbstractTest
{

   /**
    * EJB local objects are serializable. Therefore, an enterprise Web Bean may
    * declare any passivating scope.
    */
   @Test(groups = { "contexts", "passivation", "enterpriseBean", "integration" })
   @SpecAssertion(section = "8.4")
   public void testEJBWebBeanCanDeclarePassivatingScope()
   {
      deployBeans(Turku.class);
   }


   /**
    * The Web Bean manager must guarantee that JMS endpoint proxy objects are
    * serializable.
    */
   @Test(groups = { "stub", "contexts", "passivation", "jms" })
   @SpecAssertion(section = "8.4")
   public void testJMSEndpointProxyIsSerializable()
   {
      assert false;
   }
}
