package org.jboss.webbeans.tck.unit.definition.binding;


import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

import javax.inject.Current;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.CurrentBinding;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.impl.util.Reflections;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 */
public class BindingDefinitionTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }
   
   @Test @SpecAssertion(section={"2.3.3", "2.3.1"}) 
   public void testDefaultBindingDeclaredInJava()
   {      
      Bean<Order> order = createSimpleBean(Order.class);
      assert order.getBindings().size() == 1;
      order.getBindings().iterator().next().annotationType().equals(Production.class);
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.3.2")
   public void testBindingHasCorrectTarget()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.3.2")
   public void testBindingHasCorrectRetention()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.3.2")
   public void testBindingDeclaresBindingAnnotation()
   {
      assert false;
   }
   
   @SuppressWarnings("unchecked")
   @Test @SpecAssertion(section="2.3.3")
   public void testBindingsDeclaredInJava()
   {     
      Bean<Cat> cat = createSimpleBean(Cat.class);
      assert cat.getBindings().size() == 1;
      assert Reflections.annotationSetMatches(cat.getBindings(), Synchronous.class);
   }
   
   @Test @SpecAssertion(section="2.3.3") 
   public void testMultipleBindings()
   {      
      Bean<?> model = createSimpleBean(Cod.class);
      assert model.getBindings().size() == 2;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.3.4")
   public void testBindingsDeclaredInXml()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //annotations.put(Asynchronous.class, new AsynchronousAnnotationLiteral());
      //AnnotatedClass annotatedItem = new SimpleAnnotatedClass(Antelope.class, annotations);
      
      //SimpleBean<Antelope> antelope = createSimpleBean(Antelope.class, annotatedItem, manager);
      // assert Reflections.annotationSetMatches(antelope.getBindingTypes(), Asynchronous.class);
      assert false;
   }

   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.3.4")
   public void testXmlBindingOverridesAndIgnoresJava()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //annotations.put(Asynchronous.class, new AsynchronousAnnotationLiteral());
      //AnnotatedClass<Cat> annotatedItem = new SimpleAnnotatedClass<Cat>(Cat.class, annotations);
      
      //SimpleBean<Cat> cat = createSimpleBean(Cat.class, annotatedItem, manager);
      //assert cat.getBindingTypes().size() == 1;
      //assert cat.getBindingTypes().contains(new AnnotationLiteral<Asynchronous>() {});
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.3.4")
   public void testNoBindingsDeclaredInXml()
   {
      //Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //AnnotatedClass<Cat> annotatedItem = new SimpleAnnotatedClass<Cat>(Cat.class, annotations);
      
      //SimpleBean<Cat> cat = createSimpleBean(Cat.class, annotatedItem, manager);
      //assert cat.getBindingTypes().size() == 1;
      //assert cat.getBindingTypes().contains(new AnnotationLiteral<Synchronous>() {});
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section={"2.3.4", "2.3.1"}) 
   public void testDefaultBindingDeclaredInXml()
   {
      Bean<?> model = createSimpleBean(Tuna.class);
      assert model.getBindings().size() == 1;
      assert model.getBindings().contains(new CurrentBinding());
      assert false;
   }
   
   @Test(groups={"injection", "producerMethod"}) @SpecAssertion(section="2.3.5") 
   public void testFieldInjectedFromProducerMethod() throws Exception
   {
      Bean<SpiderProducer> spiderProducer = createSimpleBean(SpiderProducer.class);
      manager.addBean(spiderProducer);
      Method method = SpiderProducer.class.getMethod("produceTameTarantula");
      manager.addBean(createProducerMethodBean(method, spiderProducer));
      Barn barn = createSimpleBean(Barn.class).create(new MockCreationalContext<Barn>());
      assert barn.petSpider != null;
      assert barn.petSpider instanceof DefangedTarantula;
   }
   
   @Test(groups={"stub", "injection", "webbeansxml"}) @SpecAssertion(section="2.3.5") 
   public void testFieldWithBindingInXml()
   {
      assert false;
   }
   
   @Test(groups={"stub", "injection", "webbeansxml"}) @SpecAssertion(section="2.3.5") 
   public void testFieldWithBindingInXmlIgnoresAnnotations()
   {
      assert false;
   }
   
   @SuppressWarnings("unchecked")
   @Test(groups={"injection", "producerMethod"})
   public void testMethodWithBindingAnnotationsOnParametersAreInjected() throws Exception
   {
      Bean<SpiderProducer> spiderProducer = createSimpleBean(SpiderProducer.class);
      manager.addBean(spiderProducer);
      Method method = SpiderProducer.class.getMethod("produceTameTarantula");
      manager.addBean(createProducerMethodBean(method, spiderProducer));
      method = SpiderProducer.class.getMethod("produceSpiderFromInjection", Tarantula.class);
      Bean<Spider> spiderBean = createProducerMethodBean(method, spiderProducer);
      Spider spider = spiderBean.create(new MockCreationalContext<Spider>());
      assert spider != null;
      assert spider instanceof DefangedTarantula;
   }
   
   @Test(groups={"stub", "injection", "webbeansxml"}) @SpecAssertion(section="2.3.6") 
   public void testMethodWithBindingAnnotationsOnParametersDeclaredInXml()
   {
      assert false;
   }
   
   @Test(groups={"stub", "injection", "webbeansxml"}) @SpecAssertion(section="2.3.6") 
   public void testMethodWithBindingAnnotationsOnParametersDeclaredInXmlIgnoresAnnotations()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testBindingDeclaredInheritedIsInherited() throws Exception
   {
      Set<? extends Annotation> bindings = createSimpleBean(BorderCollie.class).getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Hairy.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testBindingNotDeclaredInheritedIsNotInherited()
   {
      Set<? extends Annotation> bindings = createSimpleBean(ShetlandPony.class).getBindings();
      assert bindings.size() == 1;
      assert bindings.iterator().next().annotationType().equals(Current.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testBindingDeclaredInheritedIsBlockedByIntermediateClass()
   {
      Set<? extends Annotation> bindings = createSimpleBean(ClippedBorderCollie.class).getBindings();
      assert bindings.size() == 1;
      Annotation binding = bindings.iterator().next();
      assert binding.annotationType().equals(Hairy.class);
      Hairy hairy = (Hairy) binding;
      assert hairy.clipped();
   }

}