package org.jboss.webbeans.tck.unit.definition.deployment;

import static org.jboss.webbeans.tck.impl.WebBeansTCKImpl.configuration;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;

import javax.inject.Standard;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class CustomDeploymentTypeTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      return Arrays.asList(Standard.class, AnotherDeploymentType.class, 
            HornedAnimalDeploymentType.class);
   }
   
   @SuppressWarnings("unchecked")
   @Test @SpecAssertion(section={"2.5.6", "2.5.7"})
   public void testCustomDeploymentTypes()
   {
      assert configuration().getManagers().getEnabledDeploymentTypes().size() == 3;
      assert configuration().getManagers().getEnabledDeploymentTypes().get(0).equals(Standard.class);
      assert configuration().getManagers().getEnabledDeploymentTypes().get(1).equals(AnotherDeploymentType.class);
      assert configuration().getManagers().getEnabledDeploymentTypes().get(2).equals(HornedAnimalDeploymentType.class);
   }
   
}
