package org.jboss.webbeans.tck.unit.definition.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

import javax.inject.DefinitionException;
import javax.inject.DeploymentException;
import javax.inject.Production;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class DeploymentTypeDefinitionTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      deploymentTypes.add(HornedAnimalDeploymentType.class);
      deploymentTypes.add(NotInheritedDeploymentType.class);
      return deploymentTypes;
   }
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section="2.5.1")
   public void testNonBuiltInComponentUsesStandard()
   {
      createSimpleBean(Gazelle_Broken.class);
   }
   
   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.5.2")
   public void testDeploymentTypeHasCorrectTarget()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.5.2")
   public void testDeploymentTypeHasCorrectRetention()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) @SpecAssertion(section="2.5.2")
   public void testDeploymentTypeDeclaresScopeTypeAnnotation()
   {
      assert false;
   }
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section="2.5.3")
   public void testTooManyDeploymentTypes()
   {
      createSimpleBean(BeanWithTooManyDeploymentTypes_Broken.class);
   }
   
   @SuppressWarnings("unchecked")
   @Test @SpecAssertion(section="2.5.3")
   public void testDeploymentTypeInhertitedFromDeclaringBean() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceBlackWidow");
      Bean<BlackWidow> blackWidowSpiderModel = createProducerMethodBean(method, bean);
      assert blackWidowSpiderModel.getDeploymentType().equals(AnotherDeploymentType.class);
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.5.4")
   public void testXmlDeploymentTypeOverridesJava()
   {
      //Map<Class<? extends Annotation>, Annotation> xmlDefinedDeploymentTypeAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
      //xmlDefinedDeploymentTypeAnnotations.put(AnotherDeploymentType.class, new AnotherDeploymentTypeAnnotationLiteral());
      //AnnotatedClass<BeanWithTooManyDeploymentTypes> xmlDefinedDeploymentTypeAnnotatedItem = new SimpleAnnotatedClass<BeanWithTooManyDeploymentTypes>(BeanWithTooManyDeploymentTypes.class, xmlDefinedDeploymentTypeAnnotations);
      
      //SimpleBean<BeanWithTooManyDeploymentTypes> model = createSimpleBean(BeanWithTooManyDeploymentTypes.class, xmlDefinedDeploymentTypeAnnotatedItem, manager);
      //assert model.getDeploymentType().equals(AnotherDeploymentType.class);
      assert false;
   }
   

   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.5.4")
   public void testXmlRespectsJavaDeploymentType()
   {
      //AnnotatedClass<Tuna> annotatedItem = new SimpleAnnotatedClass<Tuna>(Tuna.class, new HashMap<Class<? extends Annotation>, Annotation>());
      //SimpleBean<Tuna> tuna = createSimpleBean(Tuna.class, annotatedItem, manager);
      //assert tuna.getDeploymentType().equals(AnotherDeploymentType.class);
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) @SpecAssertion(section="2.5.5")
   public void testXmlDefaultDeploymentType()
   {
      //AnnotatedClass<Antelope> antelopeAnnotatedItem = new SimpleAnnotatedClass<Antelope>(Antelope.class, new HashMap<Class<? extends Annotation>, Annotation>());
      //SimpleBean<Antelope> antelope = createSimpleBean(Antelope.class, antelopeAnnotatedItem, manager);
      // assert antelope.getDeploymentType().equals(Production.class);
      assert false;
   }
   
   @Test @SpecAssertion(section="2.5.5")
   public void testHighestPrecedenceDeploymentTypeFromStereotype()
   {
      Bean<?> bean = createSimpleBean(Rhinoceros.class);
      assert bean.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }
   
   @SuppressWarnings("unchecked")
   @Test(groups="beanLifecycle", expectedExceptions=UnsatisfiedDependencyException.class) @SpecAssertion(section="2.5.6")
   public void testBeanWithDisabledDeploymentTypeNotInstantiated()
   {    
      Bean<RedSnapper> bean = createSimpleBean(RedSnapper.class);
      manager.addBean(bean);
      manager.getInstanceByType(RedSnapper.class);
   }


   

   @Test(groups={"stub", "webbeansxml"}, expectedExceptions=DeploymentException.class) @SpecAssertion(section="2.5.6")
   public void testMultipleDeployElementsCannotBeDefined()
   {
      
   }
   
   @Test @SpecAssertion(section={"2.5.5", "2.7.2", "4.1"})
   public void testWebBeanDeploymentTypeOverridesStereotype()
   {
      Bean<Reindeer> bean = createSimpleBean(Reindeer.class);
      assert bean.getDeploymentType().equals(Production.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testDeploymentTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert createSimpleBean(BorderCollie.class).getDeploymentType().equals(AnotherDeploymentType.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testDeploymentTypeNotDeclaredInheritedIsNotInherited()
   {
      assert createSimpleBean(ShetlandPony.class).getDeploymentType().equals(Production.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeNotMarkedInherited()
   {
      assert createSimpleBean(GoldenRetriever.class).getDeploymentType().equals(Production.class);
   }
   
   @Test @SpecAssertion(section="4.1")
   public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeMarkedInherited()
   {
      assert createSimpleBean(GoldenLabrador.class).getDeploymentType().equals(InheritedDeploymentType.class);
   }
   
}
