package org.jboss.webbeans.tck.unit.implementation.enterprise;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.context.Dependent;
import javax.inject.AnnotationLiteral;
import javax.inject.Current;
import javax.inject.DefinitionException;
import javax.inject.New;
import javax.inject.Standard;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.NewLiteral;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class NewEnterpriseBeanTest extends AbstractTest
{
   private Bean<WrappedEnterpriseBean> newEnterpriseBean;
   
   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>() {};
   
   @BeforeMethod
   public void initNewBean() {
      deployBeans(WrappedEnterpriseBean.class);
      Set<Bean<WrappedEnterpriseBean>> beans = manager.resolveByType(WrappedEnterpriseBean.class, new NewLiteral());
      assert beans.size() == 1;
      newEnterpriseBean = beans.iterator().next();
   }
   
   /**
    * When the built-in binding type @New is applied to an injection point, a
    * Web Bean is implicitly defined with: � scope @Dependent, � deployment type
    * 
    * @Standard, � @New as the only binding annotation, � no Web Bean name, � no
    *            stereotypes, and such that � the implementation class is the
    *            declared type of the injection point.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanIsDependentScoped()
   {
      assert Dependent.class.equals(newEnterpriseBean.getScopeType());
   }

   /**
    * When the built-in binding type @New is applied to an injection point, a
    * Web Bean is implicitly defined with: � scope @Dependent, � deployment type
    * 
    * @Standard, � @New as the only binding annotation, � no Web Bean name, � no
    *            stereotypes, and such that � the implementation class is the
    *            declared type of the injection point.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanIsOfStandardDeploymentType()
   {
      assert Standard.class.equals(newEnterpriseBean.getDeploymentType());
   }

   /**
    * When the built-in binding type @New is applied to an injection point, a
    * Web Bean is implicitly defined with: � scope @Dependent, � deployment type
    * 
    * @Standard, � @New as the only binding annotation, � no Web Bean name, � no
    *            stereotypes, and such that � the implementation class is the
    *            declared type of the injection point.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanIsHasOnlyNewBinding()
   {
      assert newEnterpriseBean.getBindings().size() == 1;
      assert newEnterpriseBean.getBindings().iterator().next().annotationType().equals(new NewLiteral().annotationType());
   }

   /**
    * When the built-in binding type @New is applied to an injection point, a
    * Web Bean is implicitly defined with: � scope @Dependent, � deployment type
    * 
    * @Standard, � @New as the only binding annotation, � no Web Bean name, � no
    *            stereotypes, and such that � the implementation class is the
    *            declared type of the injection point.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoWebBeanName()
   {
      assert newEnterpriseBean.getName() == null;
   }

   /**
    * When the built-in binding type @New is applied to an injection point, a
    * Web Bean is implicitly defined with: � scope @Dependent, � deployment type
    * 
    * @Standard, � @New as the only binding annotation, � no Web Bean name, � no
    *            stereotypes, and such that � the implementation class is the
    *            declared type of the injection point.
    */
   @Test(groups = { "stub", "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoStereotypes()
   {
      assert false;
   }

   /**
    * If the parameter type satisfies the definition of a simple Web Bean
    * implementation class, Section 3.2.1, �Which Java classes are simple Web
    * Beans?�, then the Web Bean is a simple Web Bean. If the parameter type
    * satisfies the definition of an enterprise Web Bean implementation class,
    * Section 3.3.2, �Which EJBs are enterprise Web Beans?�, then the Web Bean
    * is an enterprise Web Bean.
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanIsEnterpriseWebBeanIfParameterTypeIsEnterpriseWebBean()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasSameInitializerMethodsAsWrappedBean()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasSameInjectedFieldsAsWrappedBean()
   {
      assert false;
   }
   
   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = {"new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoObservers()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoProducerFields()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoProducerMethods()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "new", "stub" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoDisposalMethods()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "stub", "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasSameInterceptorMethodsAsWrappedBean()
   {
      assert false;
   }

   /**
    * Furthermore, this Web Bean: � has the same Web Bean constructor,
    * initializer methods and injected fields as a Web Bean defined using
    * annotations� that is, it has any Web Bean constructor, initializer method
    * or injected field declared by annotations that appear on the
    * implementation class, � has no observer methods, producer methods or
    * fields or disposal methods, � has the same interceptors as a Web Bean
    * defined using annotations�that is, it has all the interceptor binding
    * types declared by annotations that appear on the implementation class, and
    * � has no decorators.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewBeanHasNoDecorators()
   {
      Annotation[] bindingTypes = newEnterpriseBean.getBindings().toArray(new Annotation[0]);
      assert manager.resolveDecorators(newEnterpriseBean.getTypes(), bindingTypes).isEmpty();
   }

   /**
    * The @New annotation or <New> element may be applied to any field of a Web
    * Bean implementation class or to any parameter of a producer method,
    * initializer method, disposal method or Web Bean constructor where the type
    * of the field or parameter is a concrete Java type which satisfies the
    * requirements of a simple Web Bean implementation class or enterprise Web
    * Bean implementation class.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationMayBeAppliedToField()
   {
      deployBeans(AnnotatedField.class, WrappedEnterpriseBean.class);
      assert manager.resolveByType(WrappedEnterpriseBean.class, new NewLiteral()).size() == 1;
   }

   /**
    * The @New annotation or <New> element may be applied to any field of a Web
    * Bean implementation class or to any parameter of a producer method,
    * initializer method, disposal method or Web Bean constructor where the type
    * of the field or parameter is a concrete Java type which satisfies the
    * requirements of a simple Web Bean implementation class or enterprise Web
    * Bean implementation class.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationMayBeAppliedToProducerMethodParameter()
   {
      deployBeans(AnnotatedProducerParameter.class, WrappedEnterpriseBean.class);
      assert manager.resolveByType(WrappedEnterpriseBean.class, new NewLiteral()).size() == 1;
   }

   /**
    * The @New annotation or <New> element may be applied to any field of a Web
    * Bean implementation class or to any parameter of a producer method,
    * initializer method, disposal method or Web Bean constructor where the type
    * of the field or parameter is a concrete Java type which satisfies the
    * requirements of a simple Web Bean implementation class or enterprise Web
    * Bean implementation class.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationMayBeAppliedToInitializerMethodParameter()
   {
      deployBeans(AnnotatedInitializerParameter.class, WrappedEnterpriseBean.class);
      assert manager.resolveByType(WrappedEnterpriseBean.class, new NewLiteral()).size() == 1;
   }

   /**
    * The @New annotation or <New> element may be applied to any field of a Web
    * Bean implementation class or to any parameter of a producer method,
    * initializer method, disposal method or Web Bean constructor where the type
    * of the field or parameter is a concrete Java type which satisfies the
    * requirements of a simple Web Bean implementation class or enterprise Web
    * Bean implementation class.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationMayBeAppliedToConstructorMethodParameter()
   {
      deployBeans(AnnotatedConstructorParameter.class, WrappedEnterpriseBean.class);
      assert manager.resolveByType(WrappedEnterpriseBean.class, new NewLiteral()).size() == 1;
   }

   /**
    * If the @New binding type appears in conjunction with some other binding
    * type, or is specified for a field or parameter of a type which does not
    * satisfy the definition of a simple Web Bean implementation class or
    * enterprise Web Bean implementation class, a DefinitionException is thrown
    * by the container at deployment time.
    */
   @Test(groups = { "new" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationCannotAppearInConjunctionWithOtherBindingType()
   {
      deployBeans(NewAndOtherBindingType_Broken.class);
   }

   /**
    * If the @New binding type appears in conjunction with some other binding
    * type, or is specified for a field or parameter of a type which does not
    * satisfy the definition of a simple Web Bean implementation class or
    * enterprise Web Bean implementation class, a DefinitionException is thrown
    * by the container at deployment time.
    */
   @Test(groups = { "stub", "new" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationCannotBeAppliedToNonWebBeanImplementationClass()
   {
      assert false;
   }

   /**
    * No Web Bean defined using annotations or XML may explicitly declare @New
    * as a binding type
    */
   @Test(groups = { "stub", "new" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "3.3.6")
   public void testNewAnnotationCannotBeExplicitlyDeclared()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="3.2.6")
   public void testForEachEnterpriseBeanANewBeanExists()
   {
      deployBeans(Order.class, Lion.class);
      assert manager.resolveByType(Order.class).size() == 1;
      assert manager.resolveByType(Order.class).iterator().next().getBindings().size() == 1;
      assert manager.resolveByType(Order.class).iterator().next().getBindings().iterator().next().annotationType().equals(Current.class);
      
      assert manager.resolveByType(Order.class, new NewLiteral()).size() == 1;
      assert manager.resolveByType(Order.class, new NewLiteral()).iterator().next().getBindings().size() == 1;
      assert manager.resolveByType(Order.class, new NewLiteral()).iterator().next().getBindings().iterator().next().annotationType().equals(New.class);
      
      assert manager.resolveByType(Lion.class, TAME_LITERAL).size() == 1;
      assert manager.resolveByType(Lion.class, TAME_LITERAL).iterator().next().getBindings().size() == 1;
      assert manager.resolveByType(Lion.class, TAME_LITERAL).iterator().next().getBindings().iterator().next().annotationType().equals(Tame.class);
      
      assert manager.resolveByType(Lion.class, new NewLiteral()).size() == 1;
      assert manager.resolveByType(Lion.class, new NewLiteral()).iterator().next().getBindings().size() == 1;
      assert manager.resolveByType(Lion.class, new NewLiteral()).iterator().next().getBindings().iterator().next().annotationType().equals(New.class);
   }
   
}
