package org.jboss.webbeans.tck.unit.implementation.initializer;

import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
public class InitializerMethodTest extends AbstractTest
{
   
   @Test(expectedExceptions=DefinitionException.class, groups="initializerMethod") 
   @SpecAssertion(section="3.8")
   public void testStaticInitializerMethodNotAllowed()
   {
      createSimpleBean(Dottrel.class);
   }
   
   @Test(groups={"stub", "initializerMethod", "servlet"}) 
   @SpecAssertion(section="3.9")
   public void testInitializerMethodCalledOnServlet()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "ejb3"}) 
   @SpecAssertion(section="3.9")
   public void testInitializerMethodCalledOnEJBSessionBean()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "ejb3"}) 
   @SpecAssertion(section="3.9")
   public void testInitializerMethodCalledOnEJBMDB()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "ejb3", "singletons"}) 
   @SpecAssertion(section="3.9")
   public void testInitializerMethodCalledOnEJBSingleton()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "ejb3"}) 
   @SpecAssertion(section="3.9")
   public void testInitializerMethodNotABusinessMethod()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "interceptors"}) 
   @SpecAssertion(section="3.9")
   public void testMethodInterceptorNotCalledOnInitializerMethod()
   {
      assert false;
   }
   
   @Test(groups={"initializerMethod"}) 
   @SpecAssertion(section={"3.9", "5.3", "3.9.2", "3.9.3"})
   public void testMultipleInitializerMethodsAreCalled()
   {
      manager.addBean(createSimpleBean(Fox.class));
      manager.addBean(createSimpleBean(Chicken.class));
      
      Bean<ChickenHutch> chickenHutchBean = createSimpleBean(ChickenHutch.class);
      ChickenHutch chickenHutch = chickenHutchBean.create(new MockCreationalContext<ChickenHutch>());
      assert chickenHutch.fox != null;
      assert chickenHutch.chicken != null;
   }
   
   @Test(groups="initializerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section={"3.9.1", "3.4.2"})
   public void testInitializerMethodAnnotatedProduces()
   {
      createSimpleBean(Pheasant.class);
   }
   
   @Test(groups="initializerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.9.1")
   public void testInitializerMethodHasParameterAnnotatedDisposes()
   {
      createSimpleBean(Capercaillie.class);
   }
   
   @Test(groups="initializerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.9.1")
   public void testInitializerMethodHasParameterAnnotatedObserves()
   {
      createSimpleBean(Grouse.class);
   }
   
   @Test(groups={"stub", "initializerMethod", "webbeansxml"}) 
   @SpecAssertion(section="3.9.2")
   public void testInitializerMethodDeclaredInXml()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "webbeansxml"}) 
   @SpecAssertion(section="3.9.2")
   public void testInitializerMethodDeclaredInXmlIgnoresBindingAnnotationsInJava()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "webbeansxml"}, expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.9.2")
   public void testInitializerMethodDeclaredInXmlDoesNotExist()
   {
      assert false;
   }
   
   @Test(groups={"stub", "initializerMethod", "webbeansxml"}) 
   @SpecAssertion(section="3.9.2")
   public void testBeanHasAllInitializerMethodsDeclaredInJavaAndXml()
   {
      assert false;
   }
   
   /*

   @Test(groups="initializerMethod") @SpecAssertion(section="3.8")
   public void test
   {
      assert false;
   }

    */
   
}