package org.jboss.webbeans.tck.unit.implementation.producer.method;

import java.lang.reflect.Method;

import javax.context.RequestScoped;
import javax.inject.Current;
import javax.inject.DefinitionException;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class ProducerMethodDefinitionTest extends AbstractTest
{
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="2.5.3")
   public void testProducerMethodInheritsDeploymentTypeOfDeclaringWebBean() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceTameTarantula");
      Bean<Tarantula> tarantulaModel = createProducerMethodBean(method, bean);
      tarantulaModel.getDeploymentType().equals(AnotherDeploymentType.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4")
   public void testStaticMethod() throws Exception
   {
      Bean<BeanWithStaticProducerMethod> bean = createSimpleBean(BeanWithStaticProducerMethod.class);
      manager.addBean(bean);
      Method method = BeanWithStaticProducerMethod.class.getMethod("getString");
      createProducerMethodBean(method, bean);
   }
   
   @Test(groups={"stub", "producerMethod", "enterpriseBeans", "stub"}, expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4")
   public void testProducerMethodIsNotBusinessMethod() throws Exception
   {
      assert false;
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4")
   public void testParameterizedReturnType() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("getFunnelWeaverSpider");
      createProducerMethodBean(method, bean);
   }
   
   @Test(groups="producerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4")
   public void testParameterizedReturnTypeWithWildcard() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("getAnotherFunnelWeaver");
      createProducerMethodBean(method, bean);
   }
   
   @Test(groups="producerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4")
   public void testParameterizedReturnTypeWithTypeParameter() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("getFunnelWeaver");
      createProducerMethodBean(method, bean);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section={"3.4", "2.3.1"})
   public void testDefaultBindingType() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceTarantula");
      Bean<Tarantula> tarantulaModel = createProducerMethodBean(method, bean);
      assert tarantulaModel.getBindings().size() == 1;
      assert tarantulaModel.getBindings().iterator().next().annotationType().equals(Current.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.1")
   public void testApiTypeForClassReturn() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceTarantula");
      Bean<Tarantula> tarantulaModel = createProducerMethodBean(method, bean);
      assert tarantulaModel.getTypes().size() == 6;
      assert tarantulaModel.getTypes().contains(Tarantula.class);
      assert tarantulaModel.getTypes().contains(DeadlySpider.class);
      assert tarantulaModel.getTypes().contains(Spider.class);
      assert tarantulaModel.getTypes().contains(Animal.class);
      assert tarantulaModel.getTypes().contains(DeadlyAnimal.class);
      assert tarantulaModel.getTypes().contains(Object.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.1")
   public void testApiTypeForInterfaceReturn() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("makeASpider");
      Bean<Animal> animalModel = createProducerMethodBean(method, bean);
      assert animalModel.getTypes().size() == 2;
      assert animalModel.getTypes().contains(Animal.class);
      assert animalModel.getTypes().contains(Object.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.1")
   public void testApiTypeForPrimitiveReturn() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("getWolfSpiderSize");
      Bean<Integer> intModel = createProducerMethodBean(method, bean);
      assert intModel.getTypes().size() == 2;
      assert intModel.getTypes().contains(int.class);
      assert intModel.getTypes().contains(Object.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section={"3.4.1", "2.2"})
   public void testApiTypeForArrayTypeReturn() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("getSpiders");
      Bean<Spider[]> spidersModel = createProducerMethodBean(method, bean);
      assert spidersModel.getTypes().size() == 2;
      assert spidersModel.getTypes().contains(Spider[].class);
      assert spidersModel.getTypes().contains(Object.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.2")
   public void testBindingType() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceTameTarantula");
      Bean<Tarantula> tarantulaModel = createProducerMethodBean(method, bean);
      assert tarantulaModel.getBindings().size() == 1;
      assert tarantulaModel.getBindings().iterator().next().annotationType().equals(Tame.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.2")
   public void testScopeType() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceDaddyLongLegs");
      Bean<DaddyLongLegs> daddyLongLegsModel = createProducerMethodBean(method, bean);
      assert daddyLongLegsModel.getScopeType().equals(RequestScoped.class);
      
      // TODO Inherit scope from returned web bean?
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.2")
   public void testDeploymentType() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("getLadybirdSpider");
      Bean<LadybirdSpider> ladybirdSpiderModel = createProducerMethodBean(method, bean);
      assert ladybirdSpiderModel.getDeploymentType().equals(Production.class);
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.2")
   public void testNamedMethod() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceBlackWidow");
      Bean<BlackWidow> blackWidowSpiderModel = createProducerMethodBean(method, bean);
      assert blackWidowSpiderModel.getName().equals("blackWidow");
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section="3.4.2")
   public void testDefaultNamedMethod() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceDaddyLongLegs");
      Bean<DaddyLongLegs> daddyLongLegsSpiderModel = createProducerMethodBean(method, bean);
      assert daddyLongLegsSpiderModel.getName().equals("produceDaddyLongLegs");
   }
   
   @Test(groups="producerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4")
   public void testProducerMethodWithParameterAnnotatedDisposes() throws Exception
   {
      Bean<SpiderProducer_Broken> bean = createSimpleBean(SpiderProducer_Broken.class);
      manager.addBean(bean);
      Method method = SpiderProducer_Broken.class.getMethod("dispose", String.class);
      createProducerMethodBean(method, bean);
   }
   
   @Test(groups="producerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4")
   public void testProducerMethodWithParameterAnnotatedObserves() throws Exception
   {
      Bean<SpiderProducer_Broken> bean = createSimpleBean(SpiderProducer_Broken.class);
      manager.addBean(bean);
      Method method = SpiderProducer_Broken.class.getMethod("observe", String.class);
      createProducerMethodBean(method, bean);
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.3.5")
   public void testDisposalMethodNonStatic()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.3.5")
   public void testDisposalMethodMethodDeclaredOnWebBeanImplementationClass()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.3.5")
   public void testDisposalMethodBindingAnnotations()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.3.5")
   public void testDisposalMethodDefaultBindingAnnotations()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.3.5")
   public void testDisposalMethodDoesNotResolveToProducerMethod()
   {
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.4.6")
   public void testDisposalMethodDeclaredOnEnabledBean()
   {
      // TODO Placeholder
      // TODO Move this
      
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.4.6")
   public void testBeanCanDeclareMultipleDisposalMethods()
   {
      // TODO move this 
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups={"stub", "disposalMethod"}) 
   @SpecAssertion(section="3.4.6")
   public void testProducerMethodHasNoMoreThanOneDisposalMethod()
   {
      // TODO move this 
      // TODO Placeholder
      assert false;
   }
   
   @Test(groups="producerMethod") 
   @SpecAssertion(section={"2.7.2", "3.4.2", "2.2"})
   public void testStereotypeSpecifiesScope() throws Exception
   {
      Bean<SpiderProducer> bean = createSimpleBean(SpiderProducer.class);
      manager.addBean(bean);
      Method method = SpiderProducer.class.getMethod("produceWolfSpider");
      Bean<WolfSpider> wolfSpider = createProducerMethodBean(method, bean);
      //assert wolfSpiderModel.getMergedStereotypes().getRequiredTypes().size() == 1;
      //assert wolfSpiderModel.getMergedStereotypes().getRequiredTypes().contains(Animal.class);
      assert wolfSpider.getScopeType().equals(RequestScoped.class);
   }
   
   @Test(groups="producerMethod", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section={"2.7.2", "3.4.2", "2.2"})
   public void testStereotypeEnforcesTypes() throws Exception
   {
      Bean<SpiderProducer_Broken> bean = createSimpleBean(SpiderProducer_Broken.class);
      manager.addBean(bean);
      Method method = SpiderProducer_Broken.class.getMethod("produceInteger");
      createProducerMethodBean(method, bean);
   }
   
   @Test 
   @SpecAssertion(section="4.2")
   public void testNonStaticProducerMethodNotInherited()
   {
      deployBeans(InfertileChicken.class);
      assert manager.resolveByType(Egg.class).size() == 0;
   }
   
}
