package org.jboss.webbeans.tck.unit.implementation.simple;

import java.util.Date;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Current;

class Farm
{
   
   public Date founded;
   public Date closed;
   public int initialStaff;
   
   @Current
   FarmOffice farmOffice;
   
   @PostConstruct
   private void postConstruct() 
   {
      founded = new Date();
      initialStaff = farmOffice.noOfStaff;
   }
   
   @PreDestroy
   private void preDestroy() 
   {
      closed = new Date();
   }
   
}
