package org.jboss.webbeans.tck.unit.inheritance.specialization.producer.method;

import static org.jboss.webbeans.tck.impl.util.Reflections.annotationSetMatches;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.InconsistentSpecializationException;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * Spec version: PRD2
 * 
 */
public class ProducerMethodSpecializationTest extends AbstractTest
{
   
   private static Annotation EXPENSIVE_LITERAL = new AnnotationLiteral<Expensive>() {};
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
      deploymentTypes.addAll(getStandardDeploymentTypes());
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }

   @Test @SpecAssertion(section = {"4.3.1", "3.4.5"})
   public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean()
   {
      deployBeans(JewelryShop.class);
      assert manager.resolveByType(Product.class, EXPENSIVE_LITERAL).size() == 1;
      assert manager.resolveByType(Product.class, EXPENSIVE_LITERAL).iterator().next().getBindings().size() == 2;
      assert annotationSetMatches( manager.resolveByType(Product.class, EXPENSIVE_LITERAL).iterator().next().getBindings(), Expensive.class, Sparkly.class);
   }
   
   @Test @SpecAssertion(section = {"4.3.1", "3.4.5"})
   public void testSpecializingBeanHasNameOfSpecializedBean()
   {
      deployBeans(JewelryShop.class);
      assert manager.resolveByType(Product.class, new AnnotationLiteral<Sparkly>(){}).size() == 1;
      assert manager.resolveByType(Product.class, new AnnotationLiteral<Sparkly>(){}).iterator().next().getName().equals("expensiveGift");
   }
   
   @Test(expectedExceptions=DefinitionException.class) @SpecAssertion(section = "4.3.1")
   public void testSpecializingAndSpecializedBeanHasName()
   {
      deployBeans(HighSchool_Broken.class);
   }
   
   @Test @SpecAssertion(section={"4.3.1", "3.4.5"})
   public void testSpecializedBeanNotInstantiated() throws Exception
   {
      deployBeans(JewelryShop.class, Shop.class);
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            Product product = manager.getInstanceByType(Product.class, EXPENSIVE_LITERAL);
            assert product instanceof Necklace;
         }
         
      }.run();
   }
   
   @Test(expectedExceptions=InconsistentSpecializationException.class) 
   @SpecAssertion(section="4.3.1")
   public void testSpecializingBeanDoesNotHaveHigherPrecedenceThanSpecializedBean()
   {
      deployBeans(ClothesShop_Broken.class);
   }
   
   @Test(expectedExceptions=InconsistentSpecializationException.class) 
   @SpecAssertion(section="4.3.1")
   public void testTwoBeansSpecializeTheSameBean()
   {
      deployBeans(PictureShop_Broken.class, Bookshop_Broken.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4.5")
   public void testSpecializedStaticMethod()
   {
      deployBeans(FurnitureShop_Broken.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4.5")
   public void testSpecializedMethodDoesNotOverrideAnotherProducerMethod()
   {
      deployBeans(FurnitureShop_Broken.class);
   }
   
   @Test(expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="3.4.5")
   public void testSpecializedMethodIndirectlyOverridesAnotherProducerMethod()
   {
      deployBeans(ShoeShop_Broken.class);
   }

}
