package org.jboss.webbeans.tck.unit.lookup.clientProxy;

import static org.jboss.webbeans.tck.impl.WebBeansTCKImpl.configuration;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;

import javax.inject.DefinitionException;
import javax.inject.UnproxyableDependencyException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class ClientProxyTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }

   @Test(groups = "configuration().getBeans()")
   @SpecAssertion(section = { "5.4" })
   public void testClientProxyUsedForNormalScope()
   {
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      Tuna tuna = manager.getInstance(tunaBean);
      assert configuration().getBeans().isProxy(tuna);
   }

   @Test(groups = "configuration().getBeans()")
   @SpecAssertion(section = { "5.4" })
   public void testClientProxyNotUsedForPseudoScope()
   {
      Bean<Fox> foxBean = createSimpleBean(Fox.class);
      try
      {
         activateDependentContext();
         Fox fox = manager.getInstance(foxBean);
         assert !configuration().getBeans().isProxy(fox);
      }
      finally
      {
         deactivateDependentContext();
      }
   }
   
   @Test(groups = "configuration().getBeans()")
   @SpecAssertion(section = "5.4")
   public void testSimpleWebBeanClientProxyIsSerializable() throws IOException, ClassNotFoundException
   {
      Bean<TunedTuna> tunaBean = createSimpleBean(TunedTuna.class);
      manager.addBean(tunaBean);
      TunedTuna tuna = manager.getInstance(tunaBean);
      assert configuration().getBeans().isProxy(tuna);
      byte[] bytes = serialize(tuna);
      tuna = (TunedTuna) deserialize(bytes);
      assert configuration().getBeans().isProxy(tuna);
      assert tuna.getState().equals("tuned");
   }

   @Test(groups = "configuration().getBeans()", expectedExceptions = UnproxyableDependencyException.class)
   @SpecAssertion(section = "5.4.1")
   public void testInjectionPointWithUnproxyableTypeWhichResolvesToNormalScopedWebBean()
   {
      Bean<FinalTuna_Broken> tunaBean = createSimpleBean(FinalTuna_Broken.class);
      manager.addBean(tunaBean);
      @SuppressWarnings("unused")
      FinalTuna_Broken tuna = manager.getInstanceByType(FinalTuna_Broken.class);      
      assert false;
   }

   @Test(groups = "configuration().getBeans()")
   @SpecAssertion(section = "5.4.2")
   public void testClientProxyInvocation()
   {
      Bean<TunedTuna> tunaBean = createSimpleBean(TunedTuna.class);
      manager.addBean(tunaBean);
      TunedTuna tuna = manager.getInstance(tunaBean);
      assert configuration().getBeans().isProxy(tuna);
      assert tuna.getState().equals("tuned");
   }
   
   @Test(groups = "configuration().getBeans()", expectedExceptions=DefinitionException.class)
   public void testGettingUnknownBeanFails() {
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      @SuppressWarnings("unused")
      Tuna tuna = manager.getInstance(tunaBean);
      assert false;
   }

}
