package org.jboss.webbeans.tck.unit.lookup.injection;

import static org.jboss.webbeans.tck.impl.WebBeansTCKImpl.configuration;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.context.ContextNotActiveException;
import javax.inject.DefinitionException;
import javax.inject.NullableDependencyException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class InjectionTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }

   @Test(groups = { "injection", "producerMethod" })
   @SpecAssertion(section = "5.2")
   public void testInjectionPerformsBoxingIfNecessary() throws Exception
   {
      Bean<SpiderProducer> spiderProducer = createSimpleBean(SpiderProducer.class);
      manager.addBean(spiderProducer);
      Bean<SpiderNest> spiderNestBean = createSimpleBean(SpiderNest.class);
      manager.addBean(createProducerMethodBean(SpiderProducer.class.getMethod("getWolfSpiderSize"), spiderProducer));
      SpiderNest spiderNest = spiderNestBean.create(new MockCreationalContext<SpiderNest>());
      assert spiderNest.numberOfSpiders != null;
      assert spiderNest.numberOfSpiders.equals(4);
   }

   @Test(groups = { "injection", "producerMethod" }, expectedExceptions = NullableDependencyException.class)
   @SpecAssertion(section = "5.2")
   public void testPrimitiveInjectionPointResolvesToNullableWebBean() throws Exception
   {
      deployBeans(FarmHouseProducer_Broken.class, FarmHouse_Broken.class);
   }

   @Test(groups = { "injection", "clientProxy" }, expectedExceptions = ContextNotActiveException.class)
   @SpecAssertion(section = "5.3")
   public void testInvokeNormalInjectedWebBeanWhenContextNotActive()
   {
      Bean<TunaFarm> tunaFarmBean = createSimpleBean(TunaFarm.class);
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      TunaFarm tunaFarm = tunaFarmBean.create(new MockCreationalContext<TunaFarm>());
      assert tunaFarm.tuna != null;
      configuration().getContexts().setInactive(configuration().getContexts().getRequestContext());
      tunaFarm.tuna.getName();
   }

   @Test(groups = "injection")
   @SpecAssertion(section = "5.3")
   public void testInvokeDependentScopeWhenContextNotActive()
   {
      Bean<FoxRun> foxRunBean = createSimpleBean(FoxRun.class);
      Bean<Fox> foxBean = createSimpleBean(Fox.class);
      manager.addBean(foxBean);
      FoxRun foxRun = foxRunBean.create(new MockCreationalContext<FoxRun>());
      assert foxRun.fox.getName().equals("gavin");
   }

   @Test(groups = "injection", expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "3.7")
   public void testInjectingStaticField()
   {
      Bean<BeanWithStaticBoundField_Broken> bean = createSimpleBean(BeanWithStaticBoundField_Broken.class);
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      bean.create(new MockCreationalContext<BeanWithStaticBoundField_Broken>());
   }

   @Test(groups = "injection", expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "3.7")
   public void testInjectingFinalField()
   {
      Bean<BeanWithFinalBoundField_Broken> bean = createSimpleBean(BeanWithFinalBoundField_Broken.class);
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      bean.create(new MockCreationalContext<BeanWithFinalBoundField_Broken>());
   }
   
   @Test @SpecAssertion(section="4.2")
   public void testFieldDeclaredInSuperclassInjected() throws Exception
   {
      deployBeans(Fox.class, DeluxeHenHouse.class, HenHouse.class);
      
      new RunInDependentContext()
      {
        @Override
         protected void execute() throws Exception
         {
           DeluxeHenHouse henHouse = manager.getInstanceByType(DeluxeHenHouse.class);
           assert henHouse.fox != null;
           assert henHouse.fox.getName().equals("gavin");
         }
      }.run();
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "3.8.2")
   public void testInjectFieldsDeclaredInXml()
   {
      assert false;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "3.8.2")
   public void testInjectedFieldDeclaredInXmlIgnoresJavaAnnotations()
   {
      assert false;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "3.8.2")
   public void testInjectedFieldDeclaredInXmlAssumesCurrent()
   {
      assert false;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" }, expectedExceptions = DefinitionException.class)
   @SpecAssertion(section = "3.8.2")
   public void testNonexistentFieldDefinedInXml()
   {
      assert false;
   }

   @Test(groups = { "stub", "injection", "webbeansxml" })
   @SpecAssertion(section = "3.8.2")
   public void testInjectFieldsDeclaredInXmlAndJava()
   {
      assert false;
   }

}
