package org.jboss.webbeans.tck.unit.lookup.typesafe;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.inject.AmbiguousDependencyException;
import javax.inject.AnnotationLiteral;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.TypeLiteral;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;

import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.literals.CurrentBinding;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
public class InstantiationByTypeTest extends AbstractTest
{
   
   @Override
   protected List<Class<? extends Annotation>> getEnabledDeploymentTypes()
   {
      List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
      deploymentTypes.add(AnotherDeploymentType.class);
      return deploymentTypes;
   }
   
   @Test(groups={"resolution", "beanLifecycle"}) 
   @SpecAssertion(section="5.8")
   public void testCurrentBindingTypeAssumed()
   {
      Bean<Tuna> tunaBean = createSimpleBean(Tuna.class);
      manager.addBean(tunaBean);
      assert manager.getInstanceByType(Tuna.class) != null;
   }
   
   @Test(groups="resolution", expectedExceptions=IllegalArgumentException.class) 
   @SpecAssertion(section="5.8")
   public void testParameterizedTypeWithWildcardParameter()
   {
      manager.getInstanceByType(new TypeLiteral<ParameterizedBean_Broken<?>>(){});
   }
   
   @Test(groups="resolution", expectedExceptions=IllegalArgumentException.class) 
   @SpecAssertion(section="5.8")
   public  <T> void testParameterizedTypeWithTypeParameter()
   {
      manager.getInstanceByType(new TypeLiteral<ParameterizedBean_Broken<T>>(){});
   }
   
   
   @Test(groups="resolution", expectedExceptions=DuplicateBindingTypeException.class) 
   @SpecAssertion(section="5.8")
   public void testDuplicateBindingTypesUsed()
   {
      manager.getInstanceByType(Tuna.class, new CurrentBinding(), new CurrentBinding());
   }
   
   @Test(groups="resolution", expectedExceptions=IllegalArgumentException.class) 
   @SpecAssertion(section="5.8")
   public void testNonBindingTypeUsed()
   {
      manager.getInstanceByType(Tuna.class, new AnotherDeploymentTypeLiteral());
   }
   
   @Test(expectedExceptions=AmbiguousDependencyException.class) 
   @SpecAssertion(section="5.8")
   public void testAmbiguousDependencies() throws Exception
   {
      Bean<Cod> codBean = createSimpleBean(Cod.class);
      Bean<Salmon> salmonBean = createSimpleBean(Salmon.class);
      Bean<Sole> soleBean = createSimpleBean(Sole.class);
      manager.addBean(codBean);
      manager.addBean(salmonBean);
      manager.addBean(soleBean);
      manager.getInstanceByType(ScottishFish.class, new AnnotationLiteral<Whitefish>(){});
   }
   
   @Test(expectedExceptions=UnsatisfiedDependencyException.class) 
   @SpecAssertion(section="5.8")
   public void testUnsatisfiedDependencies() throws Exception
   {
      Bean<Cod> codBean = createSimpleBean(Cod.class);
      Bean<Salmon> salmonBean = createSimpleBean(Salmon.class);
      Bean<Sole> soleBean = createSimpleBean(Sole.class);
      manager.addBean(codBean);
      manager.addBean(salmonBean);
      manager.addBean(soleBean);
      manager.getInstanceByType(Tuna.class, new CurrentBinding());
   }
   
   @Test(expectedExceptions=UnproxyableDependencyException.class) 
   @SpecAssertion(section="5.8")
   public void testUnproxyableDependencies() throws Exception
   {
      deployBeans(FinalTuna_Broken.class);
      manager.getInstanceByType(FinalTuna_Broken.class, new AnnotationLiteral<Whitefish>(){});
   }   
}
