/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.integration.event;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.DefinitionException;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.integration.event.Pomeranian;
import org.jboss.webbeans.tck.integration.event.TibetanTerrier;
import org.testng.annotations.Test;

public class EventTest
extends AbstractTest {
    @Test(groups={"stub", "events", "integration"})
    @SpecAssertion(section={"7.4"})
    public void testObserverCalledBeforeTransactionCompleteMaySetRollbackOnly() {
        assert (false);
    }

    @Test(groups={"stub", "events", "integration"})
    @SpecAssertion(section={"7.4"})
    public void testObserverManipulatingJTATransactionsDirectlyFails() {
        assert (false);
    }

    @Test(groups={"events", "integration"})
    @SpecAssertion(section={"7.5"})
    public void testObserverMethodOnEnterpriseBeanIsBusinessMethodOrStatic() {
        this.deployBeans(Pomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans.size() >= 2);
        Set observers = this.manager.resolveObservers((Object)"An event", new Annotation[0]);
        assert (observers.size() == 2);
    }

    @Test(groups={"events", "integration"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.5"})
    public void testObserverMethodOnEnterpriseBeanNotBusinessMethodOrStaticFails() {
        this.deployBeans(TibetanTerrier.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans.size() >= 2);
        Set observers = this.manager.resolveObservers((Object)"An event", new Annotation[0]);
    }

    @Test(groups={"events", "integration", "broken"})
    @SpecAssertion(section={"7.5.8"})
    public void testEnterpriseBeanObserverMethodCalledWithCallerContext() {
        this.deployBeans(Pomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans.size() >= 1);
        String event = "A new event";
        Set observers = this.manager.resolveObservers((Object)event, new Annotation[0]);
        assert (observers.size() == 2);
        this.manager.fireEvent((Object)event, new Annotation[0]);
        assert (Thread.currentThread().equals(Pomeranian.notificationThread));
    }

    @Test(groups={"stub", "events", "integration"})
    @SpecAssertion(section={"7.5.8"})
    public void testTransactionalObserverThrownExceptionIsCaughtAndLogged() {
        assert (false);
    }
}

