/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.context.dependent;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.Dependent;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.WebBeansTCKImpl;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.context.dependent.Farm;
import org.jboss.webbeans.tck.unit.context.dependent.Fox;
import org.jboss.webbeans.tck.unit.context.dependent.FoxRun;
import org.jboss.webbeans.tck.unit.context.dependent.Horse;
import org.jboss.webbeans.tck.unit.context.dependent.OtherSpiderProducer;
import org.jboss.webbeans.tck.unit.context.dependent.SpiderProducer;
import org.jboss.webbeans.tck.unit.context.dependent.Stable;
import org.jboss.webbeans.tck.unit.context.dependent.Tarantula;
import org.testng.annotations.Test;

public class DependentContextTest
extends AbstractTest {
    @Test(groups={"contexts", "injection"})
    @SpecAssertion(section={"8.3"})
    public void testInstanceNotSharedBetweenInjectionPoints() {
        this.deployBeans(Fox.class, FoxRun.class);
        Set foxBeans = this.manager.resolveByType(Fox.class, new Annotation[0]);
        assert (foxBeans.size() == 1);
        Bean foxBean = (Bean)foxBeans.iterator().next();
        Set foxRunBeans = this.manager.resolveByType(FoxRun.class, new Annotation[0]);
        assert (foxRunBeans.size() == 1);
        Bean foxRunBean = (Bean)foxRunBeans.iterator().next();
        this.manager.addBean(foxBean);
        FoxRun foxRun = (FoxRun)foxRunBean.create(new MockCreationalContext());
        assert (!foxRun.fox.equals(foxRun.anotherFox));
    }

    @Test(groups={"contexts", "el"})
    @SpecAssertion(section={"8.3"})
    public void testInstanceUsedForElEvaluationNotShared() throws Exception {
        this.deployBeans(Fox.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Set foxBeans = DependentContextTest.this.manager.resolveByType(Fox.class, new Annotation[0]);
                assert (foxBeans.size() == 1);
                Bean foxBean = (Bean)foxBeans.iterator().next();
                DependentContextTest.this.manager.addBean(foxBean);
                Fox fox1 = (Fox)WebBeansTCKImpl.configuration().getContainers().evaluateValueExpression("#{fox}", Fox.class);
                Fox fox2 = (Fox)WebBeansTCKImpl.configuration().getContainers().evaluateValueExpression("#{fox}", Fox.class);
                assert (!fox1.equals(fox2));
            }
        }.run();
    }

    @Test(groups={"contexts", "producerMethod"})
    @SpecAssertion(section={"8.3"})
    public void testInstanceUsedForProducerMethodNotShared() throws Exception {
        Bean<SpiderProducer> spiderProducer = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Method method = SpiderProducer.class.getMethod("produceTarantula", new Class[0]);
        Bean tarantulaBean = this.createProducerMethodBean(method, spiderProducer);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(new MockCreationalContext());
        Tarantula tarantula2 = (Tarantula)tarantulaBean.create(new MockCreationalContext());
        assert (tarantula != null);
        assert (tarantula2 != null);
        assert (tarantula != tarantula2);
    }

    @Test(groups={"contexts", "producerMethod"})
    @SpecAssertion(section={"8.3"})
    public void testInstanceUsedForProducerFieldNotShared() throws Exception {
        Bean<OtherSpiderProducer> spiderProducer = this.createSimpleBean(OtherSpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Field field = OtherSpiderProducer.class.getField("produceTarantula");
        Bean tarantulaBean = this.createProducerFieldBean(field, spiderProducer);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(new MockCreationalContext());
        Tarantula tarantula2 = (Tarantula)tarantulaBean.create(new MockCreationalContext());
        assert (tarantula != null);
        assert (tarantula2 != null);
        assert (tarantula != tarantula2);
    }

    @Test(groups={"stub", "contexts", "disposalMethod"})
    @SpecAssertion(section={"8.3"})
    public void testInstanceUsedForDisposalMethodNotShared() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "observerMethod"})
    @SpecAssertion(section={"8.3"})
    public void testInstanceUsedForObserverMethodNotShared() {
        assert (false);
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section={"8.3"})
    public void testContextGetWithCreateTrueReturnsNewInstance() throws Exception {
        this.deployBeans(Fox.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Set foxBeans = DependentContextTest.this.manager.resolveByType(Fox.class, new Annotation[0]);
                assert (foxBeans.size() == 1);
                Bean foxBean = (Bean)foxBeans.iterator().next();
                Context context = DependentContextTest.this.manager.getContext(Dependent.class);
                assert (context.get((Contextual)foxBean, new MockCreationalContext()) != null);
                assert (context.get((Contextual)foxBean, new MockCreationalContext()) instanceof Fox);
            }
        }.run();
    }

    @Test(groups={"contexts"})
    @SpecAssertion(section={"8.3"})
    public void testContextGetWithCreateFalseReturnsNull() throws Exception {
        this.deployBeans(Fox.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Set foxBeans = DependentContextTest.this.manager.resolveByType(Fox.class, new Annotation[0]);
                assert (foxBeans.size() == 1);
                Bean foxBean = (Bean)foxBeans.iterator().next();
                Context context = DependentContextTest.this.manager.getContext(Dependent.class);
                assert (context.get((Contextual)foxBean, null) == null);
            }
        }.run();
    }

    @Test(groups={"contexts"}, expectedExceptions={ContextNotActiveException.class})
    @SpecAssertion(section={"8.3"})
    public void testContextIsInactive() {
        assert (!this.manager.getContext(Dependent.class).isActive());
    }

    @Test(groups={"stub", "contexts", "producerMethod"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveWhenInvokingProducerMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "producerField"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveWhenInvokingProducerField() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "disposalMethod"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveWhenInvokingDisposalMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "observerMethod"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveWhenInvokingObserverMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "el"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveWhenEvaluatingElExpression() {
        assert (false);
    }

    @Test(groups={"contexts", "beanLifecycle"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveDuringBeanCreation() {
        Bean<FoxRun> foxRunBean = this.createSimpleBean(FoxRun.class);
        Bean<Fox> foxBean = this.createSimpleBean(Fox.class);
        this.manager.addBean(foxBean);
        FoxRun foxRun = (FoxRun)foxRunBean.create(new MockCreationalContext());
        assert (foxRun.fox != null);
    }

    @Test(groups={"stub", "contexts", "beanDestruction"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveDuringBeanDestruction() {
        assert (false);
    }

    @Test(groups={"contexts", "injection"})
    @SpecAssertion(section={"8.4"})
    public void testContextIsActiveDuringInjection() {
        Bean<FoxRun> foxRunBean = this.createSimpleBean(FoxRun.class);
        Bean<Fox> foxBean = this.createSimpleBean(Fox.class);
        this.manager.addBean(foxBean);
        FoxRun foxRun = (FoxRun)foxRunBean.create(new MockCreationalContext());
        assert (foxRun.fox != null);
    }

    @Test(groups={"contexts", "injection", "stub", "ejb3"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveDuringEJBDependencyInjection() {
        assert (false);
    }

    @Test(groups={"contexts", "injection", "stub", "servlet"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveDuringServletDependencyInjection() {
        assert (false);
    }

    @Test(groups={"contexts", "postconstruct", "stub", "ejb3"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveDuringEJBPostConstruct() {
        assert (false);
    }

    @Test(groups={"contexts", "predestroy", "stub", "ejb3"})
    @SpecAssertion(section={"8.3"})
    public void testContextIsActiveDuringEJBPreDestroy() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "constructor"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromConstructor() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "removeMethod"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromRemoveMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "initalizerMethod"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromInitializerMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "producerMethod"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromProducerMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "disposalMethod"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromDisposalMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "preDestroy"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromPreDestroy() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "postConstruct"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromPostConstruct() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "interceptor"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromInterceptorOfActiveMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "decorator"})
    @SpecAssertion(section={"8.3.1"})
    public void testWebBeanMayCreateInstanceFromDecoratorOfActiveMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "ejb3", "initializerMethod"})
    @SpecAssertion(section={"8.3.1"})
    public void testEjbBeanMayCreateInstanceFromInitializer() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "ejb3", "postConstruct"})
    @SpecAssertion(section={"8.3.1"})
    public void testEjbBeanMayCreateInstanceFromPostConstruct() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "ejb3", "preDestroy"})
    @SpecAssertion(section={"8.3.1"})
    public void testEjbBeanMayCreateInstanceFromPreDestroy() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "ejb3", "interceptor"})
    @SpecAssertion(section={"8.3.1"})
    public void testEjbBeanMayCreateInstanceFromInterceptorOfActiveMethod() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "servlet", "initializerMethod"})
    @SpecAssertion(section={"8.3.1"})
    public void testServletBeanMayCreateInstanceFromInitializer() {
        assert (false);
    }

    @Test(groups={"broken", "contexts", "beanDestruction"})
    @SpecAssertion(section={"8.3.2"})
    public void testDestroyingParentDestroysDependents() {
        this.deployBeans(Farm.class, Horse.class, Stable.class);
        assert (this.manager.resolveByType(Farm.class, new Annotation[0]).size() == 1);
        Bean farmBean = (Bean)this.manager.resolveByType(Farm.class, new Annotation[0]).iterator().next();
        Farm farm = (Farm)this.manager.getInstanceByType(Farm.class, new Annotation[0]);
        Stable.destroyed = false;
        Horse.destroyed = false;
        farmBean.destroy((Object)farm);
        assert (Stable.destroyed);
        assert (Horse.destroyed);
    }

    @Test(groups={"stub", "contexts", "ejb3"})
    @SpecAssertion(section={"8.3.2"})
    public void testDestroyingEjbDestroysDependents() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "servlet"})
    @SpecAssertion(section={"8.3.2"})
    public void testDestroyingServletDestroysDependents() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "el"})
    @SpecAssertion(section={"8.3.2"})
    public void testDependentsDestroyedWhenElEvaluationCompletes() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "producerMethod"})
    @SpecAssertion(section={"8.3.2"})
    public void testDependentsDestroyedWhenProducerMethodCompletes() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "producerField"})
    @SpecAssertion(section={"8.3.2"})
    public void testDependentsDestroyedWhenProducerFieldCompletes() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "disposalMethod"})
    @SpecAssertion(section={"8.3.2"})
    public void testDependentsDestroyedWhenDisposalMethodCompletes() {
        assert (false);
    }

    @Test(groups={"stub", "contexts", "observerMethod"})
    @SpecAssertion(section={"8.3"})
    public void testDependentsDestroyedWhenObserverMethodEvaluationCompletes() {
        assert (false);
    }
}

