/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.definition.name;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.definition.name.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.definition.name.Haddock;
import org.jboss.webbeans.tck.unit.definition.name.Minnow;
import org.jboss.webbeans.tck.unit.definition.name.Moose;
import org.jboss.webbeans.tck.unit.definition.name.RedSnapper;
import org.jboss.webbeans.tck.unit.definition.name.SeaBass;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameDefinitionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"stub"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"2.6"})
    public void testInvalidElIdentifierUsedAsWebBeanName() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.6.1"})
    public void testNonDefaultNamed() {
        Bean<Moose> moose = this.createSimpleBean(Moose.class);
        assert (moose.getName().equals("aMoose"));
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.6.2"})
    public void testNonDefaultXmlNamed() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.6.2"})
    public void testXmlNamedOverridesJavaNamed() {
        assert (false);
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.6.2", "2.6.3"})
    public void testJavaNamedUsedWhenNoXmlSpecified() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.6.3", "3.2.7"})
    public void testDefaultNamed() {
        Bean<Haddock> haddock = this.createSimpleBean(Haddock.class);
        assert (haddock.getName() != null);
        assert (haddock.getName().equals("haddock"));
    }

    @Test(groups={"stub", "webbeansxml"})
    @SpecAssertion(section={"2.6.3"})
    public void testDefaultXmlNamed() {
        assert (false);
    }

    @Test
    @SpecAssertion(section={"2.6.3", "2.7"})
    public void testSterotypeDefaultsName() {
        Bean<RedSnapper> model = this.createSimpleBean(RedSnapper.class);
        assert (model.getName().equals("redSnapper"));
    }

    @Test
    @SpecAssertion(section={"2.6.4"})
    public void testNotNamedInJava() {
        Bean<SeaBass> model = this.createSimpleBean(SeaBass.class);
        assert (model.getName() == null);
    }

    @Test
    @SpecAssertion(section={"2.6.4"})
    public void testNotNamedInXml() {
        Bean<SeaBass> model = this.createSimpleBean(SeaBass.class);
        assert (model.getName() == null);
    }

    @Test
    @SpecAssertion(section={"2.6.4"})
    public void testNotNamedInStereotype() {
        Bean<Minnow> model = this.createSimpleBean(Minnow.class);
        assert (model.getName() == null);
    }
}

