/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.event;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.context.Dependent;
import javax.event.Event;
import javax.event.Observer;
import javax.event.ObserverException;
import javax.inject.DefinitionException;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.Standard;
import javax.inject.TypeLiteral;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.event.AnimalStereotypeAnnotationLiteral;
import org.jboss.webbeans.tck.unit.event.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.event.AuroraFinch;
import org.jboss.webbeans.tck.unit.event.AustralianTerrier;
import org.jboss.webbeans.tck.unit.event.BananaSpider;
import org.jboss.webbeans.tck.unit.event.BindingTypeABinding;
import org.jboss.webbeans.tck.unit.event.BindingTypeBBinding;
import org.jboss.webbeans.tck.unit.event.BindingTypeCBinding;
import org.jboss.webbeans.tck.unit.event.BirdCage;
import org.jboss.webbeans.tck.unit.event.BlackRumpedWaxbill_Broken;
import org.jboss.webbeans.tck.unit.event.BlueFacedParrotFinch;
import org.jboss.webbeans.tck.unit.event.BorderTerrier;
import org.jboss.webbeans.tck.unit.event.BostonTerrier;
import org.jboss.webbeans.tck.unit.event.BullTerrier;
import org.jboss.webbeans.tck.unit.event.CommonWaxbill_Broken;
import org.jboss.webbeans.tck.unit.event.Delivery;
import org.jboss.webbeans.tck.unit.event.Egg;
import org.jboss.webbeans.tck.unit.event.FarmShop;
import org.jboss.webbeans.tck.unit.event.FinchKeeper;
import org.jboss.webbeans.tck.unit.event.FiresBinding;
import org.jboss.webbeans.tck.unit.event.FoxTerrier;
import org.jboss.webbeans.tck.unit.event.GoldbreastWaxbill_Broken;
import org.jboss.webbeans.tck.unit.event.JavaSparrow_Broken;
import org.jboss.webbeans.tck.unit.event.LazyFarmer;
import org.jboss.webbeans.tck.unit.event.OrangeCheekedWaxbill;
import org.jboss.webbeans.tck.unit.event.OwlFinch_Broken;
import org.jboss.webbeans.tck.unit.event.Pomeranian;
import org.jboss.webbeans.tck.unit.event.RecluseSpider;
import org.jboss.webbeans.tck.unit.event.RoleBinding;
import org.jboss.webbeans.tck.unit.event.Shop;
import org.jboss.webbeans.tck.unit.event.StarFinch;
import org.jboss.webbeans.tck.unit.event.SweeWaxbill_Broken;
import org.jboss.webbeans.tck.unit.event.TameAnnotationLiteral;
import org.jboss.webbeans.tck.unit.event.TeaCupPomeranian;
import org.jboss.webbeans.tck.unit.event.YorkshireTerrier_Broken;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        ArrayList<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
        deploymentTypes.addAll(this.getStandardDeploymentTypes());
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.1"})
    public void testEventTypeIncludesAllSuperclassesAndInterfacesOfEventObject() {
        assert (false);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.2"})
    public void testManagerFireEvent() {
        AnEventType anEvent = new AnEventType();
        this.manager.fireEvent((Object)anEvent, new Annotation[0]);
        this.manager.fireEvent((Object)anEvent, new Annotation[]{new RoleBinding("Admin")});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.1", "7.2"})
    public void testManagerFireEventWithEventTypeParametersFails() {
        ATemplatedEventType anEvent = new ATemplatedEventType();
        this.manager.fireEvent(anEvent, new Annotation[0]);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.1", "7.2"})
    public void testManagerFireEventWithEventTypeWildcardsFails() {
        ATemplatedEventType anEventOnAnyType = new ATemplatedEventType();
        this.manager.fireEvent(anEventOnAnyType, new Annotation[0]);
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.1", "7.2"})
    public void testManagerFireEventWithNonBindingAnnotationsFails() {
        AnEventType anEvent = new AnEventType();
        this.manager.fireEvent((Object)anEvent, new Annotation[]{new AnimalStereotypeAnnotationLiteral()});
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.3"})
    public void testManagerAddObserver() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[0]);
        assert (resolvedObservers.size() == 1);
        assert (resolvedObservers.iterator().next() == observer);
        observer = new AnObserver();
        this.manager.addObserver((Observer)observer, (TypeLiteral)new TypeLiteral<AnEventType>(){}, new Annotation[0]);
        resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[0]);
        assert (resolvedObservers.size() == 2);
        boolean foundObserver = false;
        for (Observer obs : resolvedObservers) {
            if (obs != observer) continue;
            foundObserver = true;
            break;
        }
        assert (foundObserver);
        observer = new AnObserver();
        Annotation[] bindingTypes = new Annotation[]{new RoleBinding("Admin"), new RoleBinding("Manager")};
        this.manager.addObserver((Observer)observer, AnEventType.class, bindingTypes);
        resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), bindingTypes);
        assert (resolvedObservers.size() == 3);
        foundObserver = false;
        for (Observer obs : resolvedObservers) {
            if (obs != observer) continue;
            foundObserver = true;
            break;
        }
        assert (foundObserver);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.3"})
    public void testManagerRemoveObserver() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        this.manager.removeObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[0]);
        assert (resolvedObservers.isEmpty());
        observer = new AnObserver();
        this.manager.addObserver((Observer)observer, (TypeLiteral)new TypeLiteral<AnEventType>(){}, new Annotation[0]);
        this.manager.removeObserver((Observer)observer, (TypeLiteral)new TypeLiteral<AnEventType>(){}, new Annotation[0]);
        resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[0]);
        assert (resolvedObservers.isEmpty());
        Annotation[] bindings = new Annotation[]{new RoleBinding("Admin")};
        this.manager.addObserver((Observer)observer, AnEventType.class, bindings);
        this.manager.removeObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), bindings);
        assert (!resolvedObservers.isEmpty());
        this.manager.removeObserver((Observer)observer, AnEventType.class, new Annotation[]{new RoleBinding("Admin")});
        resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), bindings);
        assert (resolvedObservers.isEmpty());
    }

    @Test(groups={"events"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"7.3"})
    public void testMultipleInstancesOfSameBindingTypeWhenAddingObserverFails() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[]{new RoleBinding("Admin"), new TameAnnotationLiteral(), new TameAnnotationLiteral()});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.3"})
    public void testNonBindingTypePassedToAddObserverFails() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[]{new AnimalStereotypeAnnotationLiteral()});
    }

    @Test(groups={"events"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"7.3"})
    public void testMultipleInstancesOfSameBindingTypeWhenRemovingObserverFails() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        this.manager.removeObserver((Observer)observer, AnEventType.class, new Annotation[]{new RoleBinding("Admin"), new TameAnnotationLiteral(), new TameAnnotationLiteral()});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.3"})
    public void testNonBindingTypePassedToRemoveObserverFails() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        this.manager.removeObserver((Observer)observer, AnEventType.class, new Annotation[]{new AnimalStereotypeAnnotationLiteral()});
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.1", "7.4"})
    public void testConsumerNotifiedWhenEventTypeAndAllBindingsMatch() {
        AnObserver observer1 = new AnObserver();
        AnObserver observer2 = new AnObserver();
        this.manager.addObserver((Observer)observer1, AnEventType.class, new Annotation[0]);
        this.manager.addObserver((Observer)observer2, AnEventType.class, new Annotation[0]);
        AnEventType anEvent = new AnEventType();
        this.manager.fireEvent((Object)anEvent, new Annotation[0]);
        assert (observer1.wasNotified);
        assert (observer2.wasNotified);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.4"})
    public void testObserverThrowsExceptionAbortsNotifications() {
        boolean fireFailed;
        AnObserverWithException anotherObserver;
        AnObserverWithException observer;
        block4: {
            observer = new AnObserverWithException();
            anotherObserver = new AnObserverWithException();
            this.manager.addObserver((Observer)anotherObserver, AnEventType.class, new Annotation[0]);
            this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[0]);
            AnEventType anEvent = new AnEventType();
            fireFailed = false;
            try {
                this.manager.fireEvent((Object)anEvent, new Annotation[0]);
            }
            catch (Exception e) {
                if (!e.equals(observer.theException) && !e.equals(anotherObserver.theException)) break block4;
                fireFailed = true;
            }
        }
        assert (fireFailed);
        assert (observer.wasNotified ^ anotherObserver.wasNotified);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.5"})
    public void testMultipleObserverMethodsOK() {
        this.deployBeans(TeaCupPomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans.size() >= 2);
        Set resolvedStringObservers = this.manager.resolveObservers((Object)"A new event", new Annotation[0]);
        assert (resolvedStringObservers.size() == 1);
        Set resolvedIntegerObservers = this.manager.resolveObservers((Object)new Integer(42), new Annotation[0]);
        assert (resolvedIntegerObservers.size() == 1);
    }

    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.5.1", "7.5.2"})
    public void testObserverMethodMustHaveOnlyOneEventParameter() {
        this.deployBeans(YorkshireTerrier_Broken.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
    }

    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.5.1"})
    public void testObserverMethodCannotObserveParameterizedEvents() {
        this.deployBeans(BostonTerrier.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.5.1"})
    public void testObserverMethodWithoutBindingTypesObservesEventsWithoutBindingTypes() {
        this.deployBeans(Pomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans.size() >= 2);
        Set resolvedObservers = this.manager.resolveObservers((Object)"A new event", new Annotation[0]);
        assert (resolvedObservers.size() == 2);
    }

    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.5.2"})
    public void testObserverMethodAnnotatedProducesFails() {
        this.deployBeans(BorderTerrier.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
    }

    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.5.2"})
    public void testObserverMethodAnnotatedInitializerFails() {
        this.deployBeans(AustralianTerrier.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
    }

    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.5.2"})
    public void testObserverMethodWithDisposesParamFails() {
        this.deployBeans(FoxTerrier.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.5.2"})
    public void testObserverMethodMayHaveMultipleBindingTypes() {
        this.deployBeans(BullTerrier.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
        Set resolvedObservers = this.manager.resolveObservers((Object)"An event object", new Annotation[]{new RoleBinding("Admin"), new TameAnnotationLiteral()});
        assert (resolvedObservers.size() == 1);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.3"})
    public void testXMLDefinedObserverMethodIgnoresBindingAnnotations() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.3"})
    public void testXMLDefinedObserverNotFindingImplementationMethodFails() {
        assert (false);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.5.4"})
    public void testObserverMethodReceivesInjectionsOnNonObservesParameters() {
        this.deployBeans(BananaSpider.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertion(section={"7.5.5"})
    public void testConditionalObserver() {
        RecluseSpider.notified = false;
        this.deployBeans(RecluseSpider.class);
        this.manager.fireEvent((Object)"New string event", new Annotation[0]);
        assert (!RecluseSpider.notified);
        try {
            EventTest.activateDependentContext();
            RecluseSpider bean = (RecluseSpider)this.manager.getInstanceByType(RecluseSpider.class, new Annotation[0]);
            assert (bean != null);
            bean.toString();
            this.manager.fireEvent((Object)"Another event", new Annotation[0]);
            assert (RecluseSpider.notified);
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.1"})
    public void testTransactionalObserverCanOnlyObserveSinglePhase() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.6"})
    public void testTransactionalObserverNotifiedImmediatelyWhenNoTransactionInProgress() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.6"})
    public void testAfterTransactionCompletionObserver() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.6"})
    public void testAfterTransactionSuccessObserver() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.6"})
    public void testAfterTransactionFailureObserver() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.5.6"})
    public void testBeforeTransactionCompletionObserver() {
        assert (false);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.5.8"})
    public void testObserverMethodRegistration() {
        this.deployBeans(Pomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (beans.size() >= 2);
        Set resolvedObservers = this.manager.resolveObservers((Object)"A new event", new Annotation[0]);
        assert (resolvedObservers.size() == 2);
    }

    @Test(groups={"events"}, expectedExceptions={TeaCupPomeranian.OversizedException.class})
    @SpecAssertion(section={"7.5.8"})
    public void testNonTransactionalObserverThrownNonCheckedExceptionIsRethrown() {
        this.deployBeans(TeaCupPomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (!beans.isEmpty());
        this.manager.fireEvent((Object)"Another event", new Annotation[0]);
    }

    @Test(groups={"events"}, expectedExceptions={ObserverException.class})
    @SpecAssertion(section={"7.5.8"})
    public void testNonTransactionalObserverThrownCheckedExceptionIsWrappedAndRethrown() {
        this.deployBeans(TeaCupPomeranian.class);
        Set beans = this.manager.resolveByType(Object.class, new Annotation[0]);
        assert (!beans.isEmpty());
        this.manager.fireEvent((Object)new Integer(1), new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"7.6"})
    public void testDuplicateBindingsToFireFails() {
        this.deployBeans(SweeWaxbill_Broken.class);
        try {
            EventTest.activateDependentContext();
            SweeWaxbill_Broken bean = (SweeWaxbill_Broken)this.manager.getInstanceByType(SweeWaxbill_Broken.class, new Annotation[0]);
            bean.methodThatFiresEvent();
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"7.6"})
    public void testDuplicateBindingsToObservesFails() {
        this.deployBeans(SweeWaxbill_Broken.class);
        try {
            EventTest.activateDependentContext();
            SweeWaxbill_Broken bean = (SweeWaxbill_Broken)this.manager.getInstanceByType(SweeWaxbill_Broken.class, new Annotation[0]);
            bean.methodThatRegistersObserver();
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.6"})
    public void testNonBindingTypePassedToFireFails() {
        this.deployBeans(OwlFinch_Broken.class);
        try {
            EventTest.activateDependentContext();
            OwlFinch_Broken bean = (OwlFinch_Broken)this.manager.getInstanceByType(OwlFinch_Broken.class, new Annotation[0]);
            bean.methodThatFiresEvent();
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.6"})
    public void testNonBindingTypePassedToObservesFails() {
        this.deployBeans(OwlFinch_Broken.class);
        try {
            EventTest.activateDependentContext();
            OwlFinch_Broken bean = (OwlFinch_Broken)this.manager.getInstanceByType(OwlFinch_Broken.class, new Annotation[0]);
            bean.methodThatRegistersObserver();
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertion(section={"7.6"})
    public void testFiresAnnotationOnEventTypes() {
        Object bird;
        FinchKeeper birdKeeper;
        this.deployBeans(BlueFacedParrotFinch.class);
        try {
            EventTest.activateDependentContext();
            BlueFacedParrotFinch bean = (BlueFacedParrotFinch)this.manager.getInstanceByType(BlueFacedParrotFinch.class, new Annotation[0]);
            bean.methodThatRegistersObserver();
            Set observers = this.manager.resolveObservers((Object)"String type event", new Annotation[0]);
            assert (observers.size() == 1);
        }
        finally {
            EventTest.deactivateDependentContext();
        }
        this.deployBeans(StarFinch.class, FinchKeeper.class, BirdCage.class);
        try {
            EventTest.activateDependentContext();
            StarFinch starFinch = (StarFinch)this.manager.getInstanceByType(StarFinch.class, new Annotation[0]);
            birdKeeper = (FinchKeeper)this.manager.getInstanceByType(FinchKeeper.class, new Annotation[0]);
            BirdCage birdCage = (BirdCage)this.manager.getInstanceByType(BirdCage.class, new Annotation[0]);
            assert (starFinch != null);
            assert (birdCage != null);
            assert (birdCage.getSomeMess() != null);
            assert (birdKeeper.isNewMessDetected());
        }
        finally {
            EventTest.deactivateDependentContext();
        }
        this.deployBeans(OrangeCheekedWaxbill.class, FinchKeeper.class);
        try {
            EventTest.activateDependentContext();
            bird = (OrangeCheekedWaxbill)this.manager.getInstanceByType(OrangeCheekedWaxbill.class, new Annotation[0]);
            birdKeeper = (FinchKeeper)this.manager.getInstanceByType(FinchKeeper.class, new Annotation[0]);
            assert (bird != null);
            assert (((OrangeCheekedWaxbill)bird).getSomeMess() != null);
            assert (birdKeeper.isNewMessDetected());
        }
        finally {
            EventTest.deactivateDependentContext();
        }
        this.deployBeans(AuroraFinch.class, FinchKeeper.class);
        try {
            EventTest.activateDependentContext();
            bird = (AuroraFinch)this.manager.getInstanceByType(AuroraFinch.class, new Annotation[0]);
            birdKeeper = (FinchKeeper)this.manager.getInstanceByType(FinchKeeper.class, new Annotation[0]);
            assert (bird != null);
            assert (birdKeeper.isNewMessDetected());
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.6"})
    public void testFiresAnnotationOnNonEventTypeInjectionPointFails() {
        this.deployBeans(CommonWaxbill_Broken.class);
        try {
            EventTest.activateDependentContext();
            CommonWaxbill_Broken bean = (CommonWaxbill_Broken)this.manager.getInstanceByType(CommonWaxbill_Broken.class, new Annotation[0]);
            assert (bean != null);
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.6"})
    public void testFiresAnnotationOnInjectionPointWithoutTypeParameterFails() {
        this.deployBeans(BlackRumpedWaxbill_Broken.class);
        try {
            EventTest.activateDependentContext();
            BlackRumpedWaxbill_Broken bean = (BlackRumpedWaxbill_Broken)this.manager.getInstanceByType(BlackRumpedWaxbill_Broken.class, new Annotation[0]);
            assert (bean != null);
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.6"})
    public void testFiresAnnotationOnInjectionPointWithWildcardedTypeParameterFails() {
        this.deployBeans(GoldbreastWaxbill_Broken.class);
        try {
            EventTest.activateDependentContext();
            GoldbreastWaxbill_Broken bean = (GoldbreastWaxbill_Broken)this.manager.getInstanceByType(GoldbreastWaxbill_Broken.class, new Annotation[0]);
            assert (bean != null);
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"7.6"})
    public void testFiresAnnotationOnInjectionPointWithTypeVariabledTypeParameterFails() {
        this.deployBeans(JavaSparrow_Broken.class);
        try {
            EventTest.activateDependentContext();
            JavaSparrow_Broken bean = (JavaSparrow_Broken)this.manager.getInstanceByType(JavaSparrow_Broken.class, new Annotation[0]);
            assert (bean != null);
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertion(section={"7.6"})
    public void testImplicitEventBeanMatchesAPITypeOfInectionPoint() {
        this.deployBeans(BlueFacedParrotFinch.class);
        try {
            EventTest.activateDependentContext();
            BlueFacedParrotFinch bean = (BlueFacedParrotFinch)this.manager.getInstanceByType(BlueFacedParrotFinch.class, new Annotation[0]);
            assert (bean != null);
            Set eventBeans = this.manager.resolveByType(Event.class, new Annotation[]{new FiresBinding()});
            assert (!eventBeans.isEmpty());
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertion(section={"7.6"})
    public void testImplicitEventBeanMatchesBindingAnnotationsOfInjectionPoint() {
        this.deployBeans(OrangeCheekedWaxbill.class);
        try {
            EventTest.activateDependentContext();
            OrangeCheekedWaxbill bean = (OrangeCheekedWaxbill)this.manager.getInstanceByType(OrangeCheekedWaxbill.class, new Annotation[0]);
            assert (bean != null);
            Set eventBeans = this.manager.resolveByType(Event.class, new Annotation[]{new FiresBinding(), new TameAnnotationLiteral()});
            assert (!eventBeans.isEmpty());
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertion(section={"7.6"})
    public void testImplicitEventBeanHasStandardDeploymentType() {
        this.deployBeans(BlueFacedParrotFinch.class);
        try {
            EventTest.activateDependentContext();
            BlueFacedParrotFinch bean = (BlueFacedParrotFinch)this.manager.getInstanceByType(BlueFacedParrotFinch.class, new Annotation[0]);
            assert (bean != null);
            Set eventBeans = this.manager.resolveByType(Event.class, new Annotation[]{new FiresBinding()});
            assert (eventBeans.size() == 1);
            Bean eventBean = (Bean)eventBeans.iterator().next();
            assert (eventBean.getDeploymentType().equals(Standard.class));
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"events"})
    @SpecAssertion(section={"7.6"})
    public void testImplicitEventBeanHasDependentScope() {
        this.deployBeans(BlueFacedParrotFinch.class);
        try {
            EventTest.activateDependentContext();
            BlueFacedParrotFinch bean = (BlueFacedParrotFinch)this.manager.getInstanceByType(BlueFacedParrotFinch.class, new Annotation[0]);
            assert (bean != null);
            Set eventBeans = this.manager.resolveByType(Event.class, new Annotation[]{new FiresBinding()});
            assert (eventBeans.size() == 1);
            Bean eventBean = (Bean)eventBeans.iterator().next();
            assert (eventBean.getScopeType().equals(Dependent.class));
        }
        finally {
            EventTest.deactivateDependentContext();
        }
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.6"})
    public void testFireMethodCallsManagerFireWithEventObject() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.6"})
    public void testFireMethodCallsManagerFireWithBindingAnnotationsExceptObservable() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.6"})
    public void testFireMethodCallsManagerFireWithAllBindingAnnotationInstances() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.6"})
    public void testObserveMethodCallsManagerAddObserverWithObserverObject() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.6"})
    public void testObserveMethodCallsManagerAddObserverWithAllBindingAnnotationsExceptObservable() {
        assert (false);
    }

    @Test(groups={"stub", "events"})
    @SpecAssertion(section={"7.6"})
    public void testObserveMethodCallsManagerAddObserverWithAllBindingAnnotationInstance() {
        assert (false);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.7"})
    public void testEventObjectContainsTypeVariablesWhenResolvingFails() {
        this.eventObjectContainsTypeVariables(new ArrayList());
    }

    private <E> void eventObjectContainsTypeVariables(ArrayList<E> eventToFire) {
        Set resolvedObservers = this.manager.resolveObservers(eventToFire, new Annotation[0]);
    }

    @Test(groups={"broken", "events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.7"})
    public void testEventObjectContainsWildcardsWhenResolvingFails() {
        this.eventObjectContainsWildcards(new ArrayList());
    }

    private void eventObjectContainsWildcards(ArrayList<? extends Object> eventToFire) {
        Set resolvedObservers = this.manager.resolveObservers(eventToFire, new Annotation[0]);
    }

    @Test(groups={"events"}, expectedExceptions={DuplicateBindingTypeException.class})
    @SpecAssertion(section={"7.7"})
    public void testDuplicateBindingTypesWhenResolvingFails() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[]{new BindingTypeABinding()});
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[]{new BindingTypeABinding(), new BindingTypeABinding()});
    }

    @Test(groups={"events"}, expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section={"7.7"})
    public void testNonBindingTypeAnnotationWhenResolvingFails() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, (TypeLiteral)new TypeLiteral<AnEventType>(){}, new Annotation[0]);
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[]{new AnimalStereotypeAnnotationLiteral()});
        assert (!resolvedObservers.isEmpty());
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.7"})
    public void testResolvingChecksEventType() {
        AnObserver observer = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[0]);
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[0]);
        assert (!resolvedObservers.isEmpty());
        Set emptyObserverSet = this.manager.resolveObservers((Object)"A string event", new Annotation[0]);
        assert (emptyObserverSet.isEmpty());
    }

    @Test(groups={"broken", "events"})
    @SpecAssertion(section={"7.7"})
    public void testResolvingChecksTypeParameters() {
        AListObserver observer = new AListObserver();
        AnotherListObserver anotherObserver = new AnotherListObserver();
        this.manager.addObserver((Observer)observer, (TypeLiteral)new TypeLiteral<ArrayList<String>>(){}, new Annotation[0]);
        this.manager.addObserver((Observer)anotherObserver, (TypeLiteral)new TypeLiteral<ArrayList<Integer>>(){}, new Annotation[0]);
        Set resolvedObservers = this.manager.resolveObservers(new ArrayList(), new Annotation[0]);
        assert (resolvedObservers.size() == 1);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.7"})
    public void testResolvingChecksBindingTypes() {
        AnObserver observer = new AnObserver();
        AnObserver anotherObserver = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[]{new BindingTypeABinding()});
        this.manager.addObserver((Observer)anotherObserver, AnEventType.class, new Annotation[]{new BindingTypeBBinding()});
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[]{new BindingTypeABinding()});
        assert (resolvedObservers.size() == 1);
    }

    @Test(groups={"events"})
    @SpecAssertion(section={"7.7"})
    public void testResolvingChecksBindingTypeMembers() {
        AnObserver observer = new AnObserver();
        AnObserver anotherObserver = new AnObserver();
        this.manager.addObserver((Observer)observer, AnEventType.class, new Annotation[]{new BindingTypeCBinding("first-observer")});
        this.manager.addObserver((Observer)anotherObserver, AnEventType.class, new Annotation[]{new BindingTypeCBinding("second-observer")});
        Set resolvedObservers = this.manager.resolveObservers((Object)new AnEventType(), new Annotation[]{new BindingTypeCBinding("first-observer")});
        assert (resolvedObservers.size() == 1);
    }

    @Test(groups={"events", "inheritance"})
    @SpecAssertion(section={"4."})
    public void testNonStaticObserverMethodNotInherited() {
        this.deployBeans(LazyFarmer.class);
        assert (this.manager.resolveObservers((Object)new Egg(), new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertion(section={"7.5.8"})
    public void testObserverCalledOnMostSpecializedInstance() {
        Shop.deliveryObservedBy = null;
        this.deployBeans(FarmShop.class, Shop.class);
        this.manager.fireEvent((Object)new Delivery(), new Annotation[0]);
        assert (Shop.deliveryObservedBy.equals(FarmShop.class.getName()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnObserverWithException
    implements Observer<AnEventType> {
        public boolean wasNotified = false;
        public RuntimeException theException = new RuntimeException("RE1");

        public void notify(AnEventType event) {
            this.wasNotified = true;
            throw this.theException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnotherListObserver
    implements Observer<ArrayList<Integer>> {
        public boolean wasNotified = false;

        public void notify(ArrayList<Integer> event) {
            this.wasNotified = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AListObserver
    implements Observer<ArrayList<String>> {
        public boolean wasNotified = false;

        public void notify(ArrayList<String> event) {
            this.wasNotified = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnObserver
    implements Observer<AnEventType> {
        public boolean wasNotified = false;

        public void notify(AnEventType event) {
            this.wasNotified = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ATemplatedEventType<T> {
    }

    public static class AnEventType {
    }
}

