/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.implementation.producer.field;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.IllegalProductException;
import javax.inject.Production;
import javax.inject.Standard;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.implementation.producer.field.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.implementation.producer.field.BlackWidowConsumer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.BlackWidowProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.DefangedTarantula;
import org.jboss.webbeans.tck.unit.implementation.producer.field.HighestDeploymentType;
import org.jboss.webbeans.tck.unit.implementation.producer.field.NullSpiderConsumer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.NullSpiderProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.NullSpiderProducer_Broken;
import org.jboss.webbeans.tck.unit.implementation.producer.field.SpecializedTarantulaProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.StaticTarantulaProducer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.TarantulaConsumer;
import org.jboss.webbeans.tck.unit.implementation.producer.field.TarantulaProducer;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerFieldLifecycleTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return Collections.unmodifiableList(Arrays.asList(Standard.class, Production.class, AnotherDeploymentType.class, HighestDeploymentType.class));
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"5.6"})
    public void testProducerStaticFieldBean() {
        this.deployBeans(StaticTarantulaProducer.class, TarantulaConsumer.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                TarantulaConsumer tarantulaConsumer = (TarantulaConsumer)ProducerFieldLifecycleTest.this.manager.getInstanceByType(TarantulaConsumer.class, new Annotation[0]);
                assert (tarantulaConsumer.getConsumedTarantula().equals(StaticTarantulaProducer.produceTarantula));
            }
        };
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"6.8"})
    public void testProducerFieldBeanCreate() throws Exception {
        this.deployBeans(BlackWidowProducer.class, BlackWidowConsumer.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                BlackWidowConsumer spiderConsumer = (BlackWidowConsumer)ProducerFieldLifecycleTest.this.manager.getInstanceByType(BlackWidowConsumer.class, new Annotation[0]);
                assert (spiderConsumer.getInjectedSpider().equals(BlackWidowProducer.blackWidow));
            }
        }.run();
    }

    @Test(groups={"producerField", "specialization"})
    @SpecAssertion(section={"6.8"})
    public void testSpecializedBeanAlwaysUsed() throws Exception {
        this.deployBeans(TarantulaProducer.class, SpecializedTarantulaProducer.class, TarantulaConsumer.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                TarantulaConsumer spiderConsumer = (TarantulaConsumer)ProducerFieldLifecycleTest.this.manager.getInstanceByType(TarantulaConsumer.class, new Annotation[0]);
                assert (spiderConsumer.getConsumedTarantula() != null);
                assert (spiderConsumer.getConsumedTarantula() instanceof DefangedTarantula);
            }
        }.run();
    }

    @Test(groups={"producerField"})
    @SpecAssertion(section={"3.5", "6.8", "8.3"})
    public void testProducerFieldReturnsNullIsDependent() throws Exception {
        this.deployBeans(NullSpiderProducer.class, NullSpiderConsumer.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                NullSpiderConsumer consumerBean = (NullSpiderConsumer)ProducerFieldLifecycleTest.this.manager.getInstanceByType(NullSpiderConsumer.class, new Annotation[0]);
                assert (consumerBean.getInjectedSpider() == null);
            }
        }.run();
    }

    @Test(groups={"producerField"}, expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section={"3.5", "6.8"})
    public void testProducerFieldReturnsNullIsNotDependent() throws Exception {
        this.deployBeans(NullSpiderProducer_Broken.class, NullSpiderConsumer.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                NullSpiderConsumer consumer = (NullSpiderConsumer)ProducerFieldLifecycleTest.this.manager.getInstanceByType(NullSpiderConsumer.class, new Annotation[0]);
                if (consumer.getInjectedSpider() == null) {
                    assert (false);
                } else {
                    consumer.getInjectedSpider().bite();
                }
            }
        }.run();
    }
}

