/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.AnnotationLiteral;
import javax.inject.DefinitionException;
import javax.inject.InconsistentSpecializationException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.util.Reflections;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Building;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Cow_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Donkey_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.FarmYard_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Farmer;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.FishFarmer_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Landowner;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Lazy;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.LazyFarmer;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Office;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.OrganicFarmer_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.SheepFarmer_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Tractor_Broken;
import org.jboss.webbeans.tck.unit.inheritance.specialization.enterprise.Waste;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeanSpecializationTest
extends AbstractTest {
    private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>(){};

    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        ArrayList<Class<? extends Annotation>> deploymentTypes = new ArrayList<Class<? extends Annotation>>();
        deploymentTypes.addAll(this.getStandardDeploymentTypes());
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test
    @SpecAssertion(section={"4.3.1", "3.2.7"})
    public void testSpecializingBeanHasBindingsOfSpecializedAndSpecializingBean() {
        this.deployBeans(Farmer.class, LazyFarmer.class);
        assert (this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getTypes().contains(LazyFarmer.class));
        assert (((Bean)this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getBindings().size() == 2);
        assert (Reflections.annotationSetMatches(((Bean)this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getBindings(), Landowner.class, Lazy.class));
    }

    @Test
    @SpecAssertion(section={"4.3.1", "3.2.7"})
    public void testSpecializingBeanHasNameOfSpecializedBean() {
        this.deployBeans(Farmer.class, LazyFarmer.class);
        assert (this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).size() == 1);
        assert (((Bean)this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getTypes().contains(LazyFarmer.class));
        assert (((Bean)this.manager.resolveByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL}).iterator().next()).getName().equals("farmer"));
    }

    @Test(expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"4.3.1"})
    public void testSpecializingAndSpecializedBeanHasName() {
        this.deployBeans(FarmYard_Broken.class);
    }

    @Test(groups={"broken"})
    @SpecAssertion(section={"4.3.1", "3.2.7"})
    public void testSpecializedBeanNotInstantiated() throws Exception {
        this.deployBeans(LazyFarmer.class, Farmer.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                Farmer farmer = (Farmer)EnterpriseBeanSpecializationTest.this.manager.getInstanceByType(Farmer.class, new Annotation[]{LANDOWNER_LITERAL});
                assert (farmer.getClassName().equals(LazyFarmer.class.getName()));
            }
        }.run();
    }

    @Test(expectedExceptions={InconsistentSpecializationException.class})
    @SpecAssertion(section={"4.3.1"})
    public void testSpecializingBeanDoesNotHaveHigherPrecedenceThanSpecializedBean() {
        this.deployBeans(Farmer.class, OrganicFarmer_Broken.class);
    }

    @Test(groups={"broken"})
    @SpecAssertion(section={"4.3.1"})
    public void testProducerMethodOnSpecializedBeanCalledOnSpecializingBean() throws Exception {
        this.deployBeans(Office.class, Building.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                assert (EnterpriseBeanSpecializationTest.this.manager.resolveByType(Waste.class, new Annotation[0]).size() == 1);
                assert (((Waste)EnterpriseBeanSpecializationTest.this.manager.getInstanceByType(Waste.class, new Annotation[0])).getFrom().equals(Office.class.getName()));
            }
        }.run();
    }

    @Test(expectedExceptions={InconsistentSpecializationException.class})
    @SpecAssertion(section={"4.3.1"})
    public void testTwoBeansSpecializeTheSameBean() {
        this.deployBeans(Farmer.class, SheepFarmer_Broken.class, FishFarmer_Broken.class);
    }

    @Test(groups={"specialization"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.7"})
    public void testSpecializingClassDirectlyExtendsSimpleBean() {
        this.deployBeans(Tractor_Broken.class);
    }

    @Test(groups={"specialization"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.7"})
    public void testSpecializingClassDirectlyExtendsNothing() {
        this.deployBeans(Cow_Broken.class);
    }

    @Test(groups={"specialization"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.2.7"})
    public void testSpecializingClassImplementsInterfaceAndExtendsNothing() {
        this.deployBeans(Donkey_Broken.class);
    }

    @Test(groups={"broken", "specialization"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.3.7"})
    public void testSpecializingBeanDoesNotSupportAllLocalInterfacesOnSpecializedBean() {
        assert (false);
    }

    @Test(groups={"broken", "specialization"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.3.7"})
    public void testSpecializingBeanDoesNotSupportLocalInterfaceView() {
        assert (false);
    }
}

