/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.lookup.byname;

import javax.inject.AmbiguousDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.unit.lookup.byname.Cod;
import org.jboss.webbeans.tck.unit.lookup.byname.Haddock;
import org.jboss.webbeans.tck.unit.lookup.byname.Plaice;
import org.jboss.webbeans.tck.unit.lookup.byname.Salmon;
import org.jboss.webbeans.tck.unit.lookup.byname.SeaBass;
import org.jboss.webbeans.tck.unit.lookup.byname.Sole;
import org.jboss.webbeans.tck.unit.lookup.byname.Tuna;
import org.testng.annotations.Test;

public class InstantiationByNameTest
extends AbstractTest {
    @Test(groups={"resolution"})
    @SpecAssertion(section={"5.10"})
    public void testNoWebBeansFound() throws Exception {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        assert (this.manager.getInstanceByName("foo") == null);
    }

    @Test(expectedExceptions={AmbiguousDependencyException.class})
    @SpecAssertion(section={"5.7.1"})
    public void testAmbiguousDependencies() throws Exception {
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        this.manager.getInstanceByName("whitefish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"resolution", "beanLifecycle"})
    @SpecAssertion(section={"5.7.1"})
    public void testGetInstanceByName() {
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        Bean<Cod> codBean = this.createSimpleBean(Cod.class);
        Bean<Salmon> salmonBean = this.createSimpleBean(Salmon.class);
        Bean<Sole> soleBean = this.createSimpleBean(Sole.class);
        Bean<SeaBass> seaBassBean = this.createSimpleBean(SeaBass.class);
        Bean<Haddock> haddockBean = this.createSimpleBean(Haddock.class);
        Bean<Plaice> plaiceBean = this.createSimpleBean(Plaice.class);
        this.manager.addBean(tunaBean);
        this.manager.addBean(codBean);
        this.manager.addBean(salmonBean);
        this.manager.addBean(soleBean);
        this.manager.addBean(haddockBean);
        this.manager.addBean(seaBassBean);
        this.manager.addBean(plaiceBean);
        try {
            InstantiationByNameTest.activateDependentContext();
            assert (this.manager.getInstanceByName("salmon") instanceof Salmon);
        }
        finally {
            InstantiationByNameTest.deactivateDependentContext();
        }
    }

    @Test(groups={"stub", "resolution", "el"})
    @SpecAssertion(section={"5.10"})
    public void testGetInstanceByNameCalledOncePerDistinctNameInElExpression() {
        assert (false);
    }
}

