/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.tck.unit.lookup.injection;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.context.ContextNotActiveException;
import javax.inject.DefinitionException;
import javax.inject.NullableDependencyException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.tck.AbstractTest;
import org.jboss.webbeans.tck.impl.SpecAssertion;
import org.jboss.webbeans.tck.impl.WebBeansTCKImpl;
import org.jboss.webbeans.tck.impl.util.MockCreationalContext;
import org.jboss.webbeans.tck.unit.lookup.injection.AnotherDeploymentType;
import org.jboss.webbeans.tck.unit.lookup.injection.BeanWithFinalBoundField_Broken;
import org.jboss.webbeans.tck.unit.lookup.injection.BeanWithStaticBoundField_Broken;
import org.jboss.webbeans.tck.unit.lookup.injection.DeluxeHenHouse;
import org.jboss.webbeans.tck.unit.lookup.injection.FarmHouseProducer_Broken;
import org.jboss.webbeans.tck.unit.lookup.injection.FarmHouse_Broken;
import org.jboss.webbeans.tck.unit.lookup.injection.Fox;
import org.jboss.webbeans.tck.unit.lookup.injection.FoxRun;
import org.jboss.webbeans.tck.unit.lookup.injection.HenHouse;
import org.jboss.webbeans.tck.unit.lookup.injection.SpiderNest;
import org.jboss.webbeans.tck.unit.lookup.injection.SpiderProducer;
import org.jboss.webbeans.tck.unit.lookup.injection.Tuna;
import org.jboss.webbeans.tck.unit.lookup.injection.TunaFarm;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionTest
extends AbstractTest {
    @Override
    protected List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        List<Class<? extends Annotation>> deploymentTypes = super.getStandardDeploymentTypes();
        deploymentTypes.add(AnotherDeploymentType.class);
        return deploymentTypes;
    }

    @Test(groups={"injection", "producerMethod"})
    @SpecAssertion(section={"5.2"})
    public void testInjectionPerformsBoxingIfNecessary() throws Exception {
        Bean<SpiderProducer> spiderProducer = this.createSimpleBean(SpiderProducer.class);
        this.manager.addBean(spiderProducer);
        Bean<SpiderNest> spiderNestBean = this.createSimpleBean(SpiderNest.class);
        this.manager.addBean(this.createProducerMethodBean(SpiderProducer.class.getMethod("getWolfSpiderSize", new Class[0]), spiderProducer));
        SpiderNest spiderNest = (SpiderNest)spiderNestBean.create(new MockCreationalContext());
        assert (spiderNest.numberOfSpiders != null);
        assert (spiderNest.numberOfSpiders.equals(4));
    }

    @Test(groups={"injection", "producerMethod"}, expectedExceptions={NullableDependencyException.class})
    @SpecAssertion(section={"5.2"})
    public void testPrimitiveInjectionPointResolvesToNullableWebBean() throws Exception {
        this.deployBeans(FarmHouseProducer_Broken.class, FarmHouse_Broken.class);
    }

    @Test(groups={"injection", "clientProxy"}, expectedExceptions={ContextNotActiveException.class})
    @SpecAssertion(section={"5.3"})
    public void testInvokeNormalInjectedWebBeanWhenContextNotActive() {
        Bean<TunaFarm> tunaFarmBean = this.createSimpleBean(TunaFarm.class);
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        TunaFarm tunaFarm = (TunaFarm)tunaFarmBean.create(new MockCreationalContext());
        assert (tunaFarm.tuna != null);
        WebBeansTCKImpl.configuration().getContexts().setInactive(WebBeansTCKImpl.configuration().getContexts().getRequestContext());
        tunaFarm.tuna.getName();
    }

    @Test(groups={"injection"})
    @SpecAssertion(section={"5.3"})
    public void testInvokeDependentScopeWhenContextNotActive() {
        Bean<FoxRun> foxRunBean = this.createSimpleBean(FoxRun.class);
        Bean<Fox> foxBean = this.createSimpleBean(Fox.class);
        this.manager.addBean(foxBean);
        FoxRun foxRun = (FoxRun)foxRunBean.create(new MockCreationalContext());
        assert (foxRun.fox.getName().equals("gavin"));
    }

    @Test(groups={"injection"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.7"})
    public void testInjectingStaticField() {
        Bean<BeanWithStaticBoundField_Broken> bean = this.createSimpleBean(BeanWithStaticBoundField_Broken.class);
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        bean.create(new MockCreationalContext());
    }

    @Test(groups={"injection"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.7"})
    public void testInjectingFinalField() {
        Bean<BeanWithFinalBoundField_Broken> bean = this.createSimpleBean(BeanWithFinalBoundField_Broken.class);
        Bean<Tuna> tunaBean = this.createSimpleBean(Tuna.class);
        this.manager.addBean(tunaBean);
        bean.create(new MockCreationalContext());
    }

    @Test
    @SpecAssertion(section={"4.2"})
    public void testFieldDeclaredInSuperclassInjected() throws Exception {
        this.deployBeans(Fox.class, DeluxeHenHouse.class, HenHouse.class);
        new AbstractTest.RunInDependentContext(){

            protected void execute() throws Exception {
                DeluxeHenHouse henHouse = (DeluxeHenHouse)InjectionTest.this.manager.getInstanceByType(DeluxeHenHouse.class, new Annotation[0]);
                assert (henHouse.fox != null);
                assert (henHouse.fox.getName().equals("gavin"));
            }
        }.run();
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"3.8.2"})
    public void testInjectFieldsDeclaredInXml() {
        assert (false);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"3.8.2"})
    public void testInjectedFieldDeclaredInXmlIgnoresJavaAnnotations() {
        assert (false);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"3.8.2"})
    public void testInjectedFieldDeclaredInXmlAssumesCurrent() {
        assert (false);
    }

    @Test(groups={"stub", "injection", "webbeansxml"}, expectedExceptions={DefinitionException.class})
    @SpecAssertion(section={"3.8.2"})
    public void testNonexistentFieldDefinedInXml() {
        assert (false);
    }

    @Test(groups={"stub", "injection", "webbeansxml"})
    @SpecAssertion(section={"3.8.2"})
    public void testInjectFieldsDeclaredInXmlAndJava() {
        assert (false);
    }
}

