/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.environment.se;

import javax.context.ApplicationScoped;
import javax.event.Observes;
import javax.inject.manager.Manager;
import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.environment.se.events.Shutdown;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

@ApplicationScoped
public class ShutdownManager {
    private static LogProvider log = Logging.getLogProvider(ShutdownManager.class);
    private boolean hasShutdownBeenCalled = false;
    private Bootstrap bootstrap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(@Observes @Shutdown Manager shutdownRequest) {
        ShutdownManager shutdownManager = this;
        synchronized (shutdownManager) {
            if (!this.hasShutdownBeenCalled) {
                this.hasShutdownBeenCalled = true;
                this.bootstrap.shutdown();
            } else {
                log.debug((Object)"Skipping spurious call to shutdown");
                log.trace((Object)Thread.currentThread().getStackTrace());
            }
        }
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
}

