/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.environment.se;

import java.lang.annotation.Annotation;
import javax.inject.manager.Manager;
import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.bootstrap.api.Environment;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.environment.se.ShutdownManager;
import org.jboss.webbeans.environment.se.discovery.SEWebBeanDiscovery;
import org.jboss.webbeans.environment.se.util.Reflections;
import org.jboss.webbeans.manager.api.WebBeansManager;

public class StartMain {
    private static final String BOOTSTRAP_IMPL_CLASS_NAME = "org.jboss.webbeans.bootstrap.WebBeansBootstrap";
    private final Bootstrap bootstrap;
    private final BeanStore applicationBeanStore;
    public static String[] PARAMETERS;
    private WebBeansManager manager;

    public StartMain(String[] commandLineArgs) {
        PARAMETERS = commandLineArgs;
        try {
            this.bootstrap = Reflections.newInstance(BOOTSTRAP_IMPL_CLASS_NAME, Bootstrap.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading Web Beans bootstrap, check that Web Beans is on the classpath", e);
        }
        this.applicationBeanStore = new ConcurrentHashMapBeanStore();
    }

    private void go() {
        this.bootstrap.setEnvironment((Environment)Environments.SE);
        this.bootstrap.getServices().add(WebBeanDiscovery.class, (Service)new SEWebBeanDiscovery(){});
        this.bootstrap.setApplicationContext(this.applicationBeanStore);
        this.bootstrap.initialize();
        this.manager = this.bootstrap.getManager();
        this.bootstrap.boot();
        DependentContext.instance().setActive(true);
        ((ShutdownManager)this.bootstrap.getManager().getInstanceByType(ShutdownManager.class, new Annotation[0])).setBootstrap(this.bootstrap);
    }

    public static void main(String[] args) {
        new StartMain(args).main();
    }

    public Manager main() {
        this.go();
        return this.manager;
    }

    public static String[] getParameters() {
        return PARAMETERS;
    }
}

