/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.environment.se.discovery;

import java.net.URL;
import org.jboss.webbeans.environment.se.discovery.SEWebBeanDiscovery;
import org.jboss.webbeans.environment.se.discovery.Scanner;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

public abstract class AbstractScanner
implements Scanner {
    private static final LogProvider log = Logging.getLogProvider(Scanner.class);
    private final ClassLoader classLoader;
    private final SEWebBeanDiscovery webBeanDiscovery;

    public AbstractScanner(ClassLoader classLoader, SEWebBeanDiscovery webBeanDiscovery) {
        this.classLoader = classLoader;
        this.webBeanDiscovery = webBeanDiscovery;
    }

    protected void handle(String name, URL url) {
        if (name.endsWith(".class")) {
            String className = AbstractScanner.filenameToClassname(name);
            try {
                this.webBeanDiscovery.getWbClasses().add(this.getClassLoader().loadClass(className));
            }
            catch (NoClassDefFoundError e) {
                log.error((Object)("Error loading " + name), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Error loading " + name), (Throwable)e);
            }
        } else if (name.endsWith("beans.xml")) {
            this.webBeanDiscovery.getWbUrls().add(url);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

