/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.plugins;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.wildscribe.modeldumper.Configuration;
import org.jboss.wildscribe.modeldumper.ModelExporter;
import org.jboss.wildscribe.site.Generator;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.core.ContainerDescription;
import org.wildfly.plugin.core.ServerHelper;
import org.wildscribe.logs.MessageExporter;

@Mojo(name="generate-site")
public class GenerateSiteMojo
extends AbstractMojo {
    @Parameter(alias="jboss-home", property="wildscribe.jboss.home", required=true)
    private String jbossHome;
    @Parameter(property="wildscribe.management.protocol")
    private String protocol;
    @Parameter(defaultValue="localhost", property="wildscribe.management.hostname")
    private String hostname;
    @Parameter(defaultValue="9990", property="wildscribe.management.port")
    private int port;
    @Parameter(alias="java-opts", property="wildscribe.java.opts")
    private String[] javaOpts;
    @Parameter(alias="server-config", defaultValue="standalone-full-ha.xml", property="wildscribe.server.config")
    private String serverConfig;
    @Parameter(alias="model-dir", defaultValue="${project.build.directory}/wildscribe", property="wildscribe.model.dir")
    private String modelDir;
    @Parameter(alias="site-dir", defaultValue="${project.build.directory}/wildscribe", property="wildscribe.site.dir")
    private String siteDir;
    @Parameter(alias="display-name", property="wildscribe.display.name")
    private String displayName;
    @Parameter(alias="display-version", property="wildscribe.display.version")
    private String displayVersion;
    @Parameter(alias="required-extensions", property="wildscribte.required.extensions")
    private List<String> requiredExtensions;
    @Parameter(defaultValue="false", property="wildscribe.skip")
    private boolean skip;
    @Parameter(defaultValue="60", property="wildscribe.timeout")
    private int timeout;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        Path wildflyHome = Paths.get(this.jbossHome, new String[0]);
        if (!ServerHelper.isValidHomeDirectory((Path)wildflyHome)) {
            throw new MojoExecutionException(String.format("Invalid directory %s is not a valid JBoss Home directory.", this.jbossHome));
        }
        StandaloneCommandBuilder commandBuilder = this.createCommandBuilder(wildflyHome);
        Process process = null;
        try {
            Path consoleRedirect = wildflyHome.resolve("standalone").resolve("logs").resolve("console-output.log");
            if (Files.notExists(consoleRedirect.getParent(), new LinkOption[0])) {
                Files.createDirectories(consoleRedirect.getParent(), new FileAttribute[0]);
            }
            process = this.startContainer((CommandBuilder)commandBuilder, consoleRedirect);
            try (ModelControllerClient client = this.createClient();){
                ContainerDescription containerDescription = ServerHelper.getContainerDescription((ModelControllerClient)client);
                String baseFileName = containerDescription.getProductName().replace(' ', '-') + '-' + containerDescription.getProductVersion();
                Path dmrFile = this.createModel(client, baseFileName, containerDescription);
                this.createMessageFile(wildflyHome, dmrFile.getParent(), baseFileName);
                Path siteTarget = Paths.get(this.siteDir, new String[0]);
                if (Files.notExists(siteTarget, new LinkOption[0])) {
                    Files.createDirectories(siteTarget, new FileAttribute[0]);
                }
                Generator.generate((Path)dmrFile, (Path)siteTarget, (String)this.displayName, (String)this.displayVersion);
            }
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new MojoExecutionException("Failed to generate the Wildscribe sight.", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    private StandaloneCommandBuilder createCommandBuilder(Path wildflyPath) {
        StandaloneCommandBuilder commandBuilder = StandaloneCommandBuilder.of((Path)wildflyPath).setServerConfiguration(this.serverConfig);
        if (this.hostname != null) {
            commandBuilder.setBindAddressHint("management", this.hostname);
        }
        if (this.port > 0) {
            commandBuilder.addJavaOptions(new String[]{"-Djboss.management.http.port=" + this.port});
        }
        if (this.javaOpts != null && this.javaOpts.length > 0) {
            commandBuilder.setJavaOptions(this.javaOpts);
        }
        return commandBuilder;
    }

    private Process startContainer(CommandBuilder commandBuilder, Path consoleRedirct) throws IOException, InterruptedException, TimeoutException {
        Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true).redirectOutput(consoleRedirct);
        Process process = launcher.launch();
        try (ModelControllerClient client = this.createClient();){
            ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.timeout);
        }
        return process;
    }

    private Path createModel(ModelControllerClient client, String baseFileName, ContainerDescription containerDescription) throws MojoExecutionException {
        Path dmrFile;
        Path targetDir = Paths.get(this.modelDir, new String[0]);
        if (Files.notExists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create directories for " + targetDir, (Exception)e);
            }
        }
        try {
            ModelNode op;
            Configuration configuration = Configuration.of((Path)targetDir.resolve(baseFileName + ".dmr")).setProtocol(this.protocol).setHostName(this.hostname).setPort(this.port);
            if (this.requiredExtensions != null && !this.requiredExtensions.isEmpty()) {
                configuration.addRequiredExtensions(this.requiredExtensions);
                op = Operations.createOperation((String)"read-children-names");
                op.get("child-type").set("extension");
                ArrayList<String> extensionsToAdd = new ArrayList<String>(this.requiredExtensions);
                extensionsToAdd.removeAll(GenerateSiteMojo.executeForResult(client, op, "Failed to read the current extensions", new Object[0]).asList().stream().map(ModelNode::asString).collect(Collectors.toList()));
                Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
                for (String name : extensionsToAdd) {
                    builder.addStep(Operations.createAddOperation((ModelNode)Operations.createAddress((String[])new String[]{"extension", name})));
                }
                GenerateSiteMojo.executeForResult(client, builder.build(), "Failed to add the following extensions %s", extensionsToAdd);
            }
            dmrFile = ModelExporter.toDmr((Configuration)configuration);
            op = Operations.createOperation((String)"shutdown");
            op.get("timeout").set(10);
            GenerateSiteMojo.executeForResult(client, op, "Failed to shutdown the server %s", configuration);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to export the server model " + containerDescription, (Exception)e);
        }
        return dmrFile;
    }

    private void createMessageFile(Path wildflyHome, Path dir, String baseFileName) throws MojoExecutionException {
        try {
            MessageExporter.export((Path)wildflyHome.resolve("modules"), (Path)dir.resolve(baseFileName + ".messages"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create the message file for directory " + wildflyHome, (Exception)e);
        }
    }

    private ModelControllerClient createClient() throws UnknownHostException {
        return ModelControllerClient.Factory.create((String)this.protocol, (String)this.hostname, (int)this.port);
    }

    private static ModelNode executeForResult(ModelControllerClient client, ModelNode op, String failureMessage, Object ... args) throws MojoExecutionException {
        return GenerateSiteMojo.executeForResult(client, Operation.Factory.create((ModelNode)op), failureMessage, args);
    }

    private static ModelNode executeForResult(ModelControllerClient client, Operation op, String failureMessage, Object ... args) throws MojoExecutionException {
        try {
            ModelNode result = client.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)result)) {
                return Operations.readResult((ModelNode)result);
            }
            throw new MojoExecutionException(String.format(failureMessage, args) + ": " + Operations.getFailureDescription((ModelNode)result));
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format(failureMessage, args), (Exception)e);
        }
    }

    static {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }
}

