/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import org.jboss.dmr.Property;

public class PathElement {
    public static final String WILDCARD_VALUE = "*";
    private final String key;
    private final String value;
    private final boolean multiTarget;
    private final int hashCode;

    public static PathElement pathElement(String key) {
        return new PathElement(key);
    }

    public static PathElement pathElement(String key, String value) {
        return new PathElement(key, value);
    }

    PathElement(String key) {
        this(key, WILDCARD_VALUE);
    }

    PathElement(String key, String value) {
        if (!PathElement.isValidKey(key)) {
            String element = key + "=" + value;
            throw new OperationClientIllegalArgumentException(String.format("Invalid resource address element '%s'. The key '%s' is not valid for an element in a resource address.", element, key));
        }
        if (value == null || value.isEmpty()) {
            String element = key + "=" + value;
            throw new OperationClientIllegalArgumentException(String.format("Invalid resource address element '%s'. The value '%s' is not valid for an element in a resource address. Character '%s' is not allowed.", element, value, Character.valueOf(' ')));
        }
        boolean multiTarget = false;
        if (key.equals(WILDCARD_VALUE)) {
            this.key = WILDCARD_VALUE;
            multiTarget = true;
        } else {
            this.key = key;
        }
        if (value.equals(WILDCARD_VALUE)) {
            this.value = WILDCARD_VALUE;
            multiTarget = true;
        } else if (value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
            this.value = value.substring(1, value.length() - 1);
            multiTarget |= value.indexOf(44) != -1;
        } else {
            this.value = value;
        }
        this.multiTarget = multiTarget;
        this.hashCode = key.hashCode() * 19 + value.hashCode();
    }

    private static boolean isValidKey(String s) {
        if (s == null) {
            return false;
        }
        if (s.equals(WILDCARD_VALUE)) {
            return true;
        }
        int lastIndex = s.length() - 1;
        if (lastIndex == -1) {
            return false;
        }
        if (!PathElement.isValidKeyStartCharacter(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < lastIndex; ++i) {
            if (PathElement.isValidKeyCharacter(s.charAt(i))) continue;
            return false;
        }
        return lastIndex <= 0 || PathElement.isValidKeyEndCharacter(s.charAt(lastIndex));
    }

    private static boolean isValidKeyStartCharacter(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isValidKeyEndCharacter(char c) {
        return c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isValidKeyCharacter(char c) {
        return c == '_' || c == '-' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean matches(Property property) {
        return property.getName().equals(this.key) && (this.value == WILDCARD_VALUE || property.getValue().asString().equals(this.value));
    }

    public boolean isWildcard() {
        return WILDCARD_VALUE == this.value;
    }

    public boolean isMultiTarget() {
        return this.multiTarget;
    }

    public String[] getSegments() {
        return this.value.split(",");
    }

    public String[] getKeyValuePair() {
        return new String[]{this.key, this.value};
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof PathElement && this.equals((PathElement)other);
    }

    public boolean equals(PathElement other) {
        return this == other || other != null && other.key.equals(this.key) && other.value.equals(this.value);
    }

    public String toString() {
        return "\"" + this.key + "\" => \"" + this.value + "\"";
    }

    private static class OperationClientIllegalArgumentException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -9073168544821068948L;

        private OperationClientIllegalArgumentException(String msg) {
            super(msg);
            assert (msg != null) : "msg is null";
        }
    }
}

