/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.wildscribe.site.Attribute;
import org.jboss.wildscribe.site.Capability;
import org.jboss.wildscribe.site.Child;
import org.jboss.wildscribe.site.Deprecated;
import org.jboss.wildscribe.site.Operation;
import org.jboss.wildscribe.site.PathAddress;

public class ResourceDescription {
    private final String description;
    private final List<Child> children;
    private final List<Attribute> attributes;
    private final List<Operation> operations;
    private final Deprecated deprecated;
    private final List<Capability> capabilities;
    private final String storage;

    public ResourceDescription(String description, List<Child> children, List<Attribute> attributes, List<Operation> operations, Deprecated deprecated, List<Capability> capabilities, String storage) {
        this.description = description;
        this.children = children;
        this.attributes = attributes;
        this.operations = operations;
        this.deprecated = deprecated;
        this.capabilities = capabilities;
        this.storage = storage;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Child> getChildren() {
        return this.children;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public String getStorage() {
        return this.storage;
    }

    public boolean isRuntime() {
        return "runtime-only".equals(this.storage);
    }

    public static ResourceDescription fromModelNode(PathAddress pathElements, ModelNode node, Map<String, Capability> capabilities) {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        if (node.hasDefined("operations")) {
            for (Property property : node.get("operations").asPropertyList()) {
                ops.add(Operation.fromProperty(property));
            }
        }
        Collections.sort(ops);
        ArrayList<Child> children = new ArrayList<Child>();
        if (node.hasDefined("children")) {
            for (Property property : node.get("children").asPropertyList()) {
                children.add(Child.fromProperty(property));
            }
            Collections.sort(children);
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (node.hasDefined("attributes")) {
            for (Property i : node.get("attributes").asPropertyList()) {
                arrayList.add(Attribute.fromProperty(i));
            }
            Collections.sort(arrayList);
        }
        String string = node.get("storage").asString("configuration");
        return new ResourceDescription(node.get("description").asString(), children, arrayList, ops, Deprecated.fromModel(node), Capability.fromModelList(node.get("capabilities"), capabilities, pathElements), string);
    }
}

