/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.wildscribe.site.PathAddress;
import org.jboss.wildscribe.site.PathElement;

public class Capability {
    private final String name;
    private final boolean dynamic;
    private final List<String> providerPoints;
    private final Map<String, String> providerPointsUrls;

    private Capability(String name, boolean dynamic, List<String> providerPoints) {
        this.name = name;
        this.dynamic = dynamic;
        this.providerPoints = providerPoints;
        this.providerPointsUrls = this.calculateProviderPointsUrls(providerPoints);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public List<String> getProviderPoints() {
        return this.providerPoints;
    }

    public Map<String, String> calculateProviderPointsUrls(List<String> points) {
        Map<String, String> resolved = points.stream().collect(Collectors.toMap(s -> s, v -> {
            PathAddress address = PathAddress.parseCLIStyleAddress(v);
            StringBuilder url = new StringBuilder();
            for (PathElement pe : address) {
                if (pe.isWildcard()) {
                    url.append(pe.getKey()).append('/');
                    continue;
                }
                url.append(pe.getKey()).append('/').append(pe.getValue()).append('/');
            }
            return url.toString();
        }));
        return resolved;
    }

    public Map<String, String> getProviderPointsUrls() {
        return this.providerPointsUrls;
    }

    static Capability fromModel(ModelNode capability, Map<String, Capability> globalCaps, String currentResourcePath) {
        List<String> providerPoints;
        String name = capability.get("name").asString();
        boolean dynamic = capability.get("dynamic").asBoolean(false);
        if (capability.hasDefined("registration-points")) {
            List<ModelNode> registrationPoints = capability.get("registration-points").asList();
            providerPoints = registrationPoints.stream().map(ModelNode::asString).collect(Collectors.toList());
        } else {
            providerPoints = globalCaps.containsKey(name) ? globalCaps.get(name).getProviderPoints().stream().filter(s -> !s.equals(currentResourcePath)).collect(Collectors.toList()) : Collections.emptyList();
        }
        return new Capability(name, dynamic, providerPoints);
    }

    static List<Capability> fromModelList(ModelNode capModel, Map<String, Capability> capabilities, PathAddress pathElements) {
        if (!capModel.isDefined()) {
            return Collections.emptyList();
        }
        LinkedList<Capability> r = new LinkedList<Capability>();
        capModel.asList().forEach(c -> r.add(Capability.fromModel(c, capabilities, pathElements.toCLIStyleString())));
        return r;
    }

    public String getCapabilityDescriptionUrl() {
        StringBuilder url = new StringBuilder("https://github.com/wildfly/wildfly-capabilities/tree/master/");
        return url.append(this.name.replaceAll("\\.", "/")).append("/capability.adoc").toString();
    }
}

