/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.wildscribe.site.Deprecated;

public class Child
implements Comparable<Child> {
    private final String name;
    private final String description;
    private final Deprecated deprecated;
    private final List<Child> children;

    public Child(String name, String description, Deprecated deprecated, List<Child> children) {
        this.name = name;
        this.description = description;
        this.deprecated = deprecated;
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    public List<Child> getChildren() {
        return this.children;
    }

    @Override
    public int compareTo(Child o) {
        return this.name.compareTo(o.getName());
    }

    public static Child fromProperty(Property property) {
        String name = property.getName();
        String description = property.getValue().get("description").asString();
        ArrayList<Child> registrations = new ArrayList<Child>();
        ModelNode modelDesc = property.getValue().get("model-description");
        if (modelDesc.isDefined()) {
            for (Property child : modelDesc.asPropertyList()) {
                if (child.getName().equals("*")) continue;
                registrations.add(new Child(child.getName(), child.getValue().get("description").asString(""), Deprecated.fromModel(child.getValue()), null));
            }
        }
        Collections.sort(registrations);
        Child op = new Child(name, description, Deprecated.fromModel(property.getValue()), registrations);
        return op;
    }
}

