/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;

class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getPackage().getName());

    private FileUtils() {
    }

    static Path getUserHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    static Path getPath(String path) {
        if (path.charAt(0) == '~') {
            if (path.charAt(1) == File.separatorChar) {
                return FileUtils.getUserHome().resolve(path.substring(2)).toAbsolutePath();
            }
            return FileUtils.getUserHome().resolve(path.substring(1)).toAbsolutePath();
        }
        return Paths.get(path, new String[0]);
    }

    static Path createTempDir(String path) {
        return Paths.get(System.getProperty("java.io.tmpdir"), path);
    }

    static void delete(final Path dir, final boolean ignoreHidden) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                return Files.isHidden(dir2) && ignoreHidden ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isHidden(file) || !ignoreHidden) {
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path d, IOException exc) throws IOException {
                if (!dir.equals(d)) {
                    Files.delete(d);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static Path copyDirectoryFromJar(URL resource) throws IOException {
        Path tmpDir = FileUtils.createTempDir("wildscribe_templates");
        if (Files.exists(tmpDir, new LinkOption[0])) {
            FileUtils.delete(tmpDir, false);
        }
        FileUtils.copyDirectoryFromJar(resource, tmpDir);
        return tmpDir;
    }

    static void copyDirectoryFromJar(URL resource, Path dest) throws IOException {
        LOGGER.debugf("Copying %s to %s", (Object)resource, (Object)dest);
        if ("file".equals(resource.getProtocol())) {
            try {
                Path src = Paths.get(resource.toURI());
                Files.walkFileTree(src, new CopyDirVisitor(src, dest, StandardCopyOption.REPLACE_EXISTING));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else if ("jar".equals(resource.getProtocol())) {
            int endIndex = resource.getFile().indexOf(33);
            JarFile file = new JarFile(resource.getFile().substring(5, endIndex));
            String path = resource.getPath().substring(endIndex + 2);
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(path)) continue;
                LOGGER.debugf("Copying %s", (Object)entry.getName().substring(path.length() + 1));
                Path fileDest = dest.resolve(entry.getName().substring(path.length() + 1));
                if (Files.notExists(fileDest.getParent(), new LinkOption[0])) {
                    Files.createDirectories(fileDest.getParent(), new FileAttribute[0]);
                }
                Files.copy(file.getInputStream(entry), fileDest, new CopyOption[0]);
            }
        } else {
            throw new RuntimeException("Unknown scheme " + resource.getProtocol());
        }
    }

    private static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final Path toPath;
        private final CopyOption copyOption;

        CopyDirVisitor(Path fromPath, Path toPath, CopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOption = copyOption;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }
}

