/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.wildscribe.site.FileUtils;
import org.jboss.wildscribe.site.SiteGenerator;
import org.jboss.wildscribe.site.Version;

public class Generator {
    private static final Logger LOGGER = Logger.getLogger(Generator.class);
    private static final String VERSION = "versions.txt";
    private static final String STATICRESOURCES = "staticresources";
    private static final String TEMPLATES = "templates";

    public static Path generate(Path modelPath, Path target) throws IOException {
        return Generator.generate(modelPath, target, null, null);
    }

    public static Path generate(Path modelPath, Path target, String displayName, String displayVersion) throws IOException {
        List<Version> versions = Files.isDirectory(Objects.requireNonNull(modelPath, "The target cannot be null."), new LinkOption[0]) ? Generator.loadVersions(modelPath) : Collections.singletonList(Generator.resolveVersion(modelPath, displayName, displayVersion));
        return Generator.generate(versions, target);
    }

    public static Path generate(Collection<Path> modelPaths, Path target) throws IOException {
        return Generator.generate(modelPaths, target, null, null);
    }

    public static Path generate(Collection<Path> modelPaths, Path target, String displayName, String displayVersion) throws IOException {
        if (modelPaths.isEmpty()) {
            throw new IllegalArgumentException("No module paths were defined.");
        }
        ArrayList<Version> versions = new ArrayList<Version>(modelPaths.size());
        if (modelPaths.size() > 1) {
            for (Path modelPath : modelPaths) {
                if (Files.isDirectory(modelPath, new LinkOption[0])) {
                    versions.addAll(Generator.loadVersions(modelPath));
                    continue;
                }
                versions.add(Generator.resolveVersion(modelPath, displayName, displayVersion));
            }
        } else {
            versions.add(Generator.resolveVersion(modelPaths.iterator().next(), displayName, displayVersion));
        }
        return Generator.generate(versions, target);
    }

    private static Path generate(List<Version> versions, Path target) throws IOException {
        if (Files.notExists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        } else {
            FileUtils.delete(target, true);
        }
        Path templateDir = FileUtils.copyDirectoryFromJar(Generator.getResource(TEMPLATES));
        LOGGER.infof("Generating site in %s", (Object)target);
        FileUtils.copyDirectoryFromJar(Generator.getResource(STATICRESOURCES), target);
        Configuration configuration = Generator.createFreemarkerConfig(templateDir);
        try {
            SiteGenerator siteGenerator = new SiteGenerator(versions, configuration, target);
            if (versions.size() > 1) {
                siteGenerator.createMainPage();
                siteGenerator.createAboutPage();
                siteGenerator.createVersions();
            } else {
                siteGenerator.createSingleVersion();
            }
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        return target;
    }

    private static Version resolveVersion(Path path, String displayName, String displayVersion) throws IOException {
        if (displayName != null && displayVersion != null) {
            return new Version(displayName, displayVersion, path.toFile());
        }
        ModelNode fullModel = new ModelNode();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            fullModel.readExternal(in);
        }
        if (!fullModel.hasDefined("version-info")) {
            return new Version("unknown", "unknown", path.toFile());
        }
        ModelNode model = fullModel.get("version-info");
        String productName = displayName == null ? model.get("product-name").asString() : displayName;
        String productVersion = displayVersion == null ? model.get("product-version").asString() : displayVersion;
        return new Version(productName, productVersion, path.toFile());
    }

    private static Configuration createFreemarkerConfig(Path templateDir) throws IOException {
        freemarker.template.Version freemakerVersion = new freemarker.template.Version(2, 3, 20);
        Configuration cfg = new Configuration(freemakerVersion);
        cfg.setDirectoryForTemplateLoading(templateDir.toFile());
        cfg.setObjectWrapper(new DefaultObjectWrapper(freemakerVersion));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        cfg.setURLEscapingCharset("UTF-8");
        return cfg;
    }

    private static List<Version> loadVersions(Path modelDir) throws IOException {
        ArrayList<Version> ret = new ArrayList<Version>();
        List<String> versions = Files.readAllLines(modelDir.resolve(VERSION), StandardCharsets.UTF_8);
        for (String version : versions) {
            String[] parts = version.split(":");
            ret.add(new Version(parts[0], parts[1], modelDir.resolve(parts[2]).toFile()));
        }
        return ret;
    }

    private static URL getResource(String path) {
        ClassLoader cl;
        URL url = Generator.class.getClassLoader().getResource(path);
        if (url == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            url = cl.getResource(path);
        }
        if (url == null) {
            throw new RuntimeException("Failed to locate resource " + path);
        }
        return url;
    }
}

