/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.dmr.ModelNode;
import org.jboss.wildscribe.site.Breadcrumb;
import org.jboss.wildscribe.site.Capability;
import org.jboss.wildscribe.site.Child;
import org.jboss.wildscribe.site.PathAddress;
import org.jboss.wildscribe.site.PathElement;
import org.jboss.wildscribe.site.ResourceDescription;
import org.jboss.wildscribe.site.Version;

class SingleVersionGenerator {
    public static final String RESOURCE_HTML = "resource.html";
    private static final String LOG_MESSAGE_REFERENCE_HTML = "log-message-reference.html";
    private static final String LOGS_HTML = "logs.html";
    public final String layoutHtml;
    private final Map<String, Capability> capabilities = new LinkedHashMap<String, Capability>();
    private final List<Version> versions;
    private final Version version;
    private final Configuration configuration;
    private final Path outputDir;
    private boolean single = false;

    SingleVersionGenerator(List<Version> versions, Version version, Configuration configuration, Path outputDir, String layoutHtml) {
        this.versions = versions;
        this.version = version;
        this.configuration = configuration;
        this.outputDir = outputDir;
        this.layoutHtml = layoutHtml;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public void generate() throws IOException, TemplateException {
        List<LogMessage> messages = this.loadLogMessages();
        ModelNode model = new ModelNode();
        model.readExternal(new FileInputStream(this.version.getDmrFile()));
        this.capabilities.putAll(this.getCapabilityMap(model));
        Template template = this.configuration.getTemplate(this.layoutHtml);
        this.createResourcePage(model, template, messages != null, new PathElement[0]);
        if (messages != null) {
            this.createLogMessagePage(template, messages);
        }
    }

    private List<LogMessage> loadLogMessages() throws IOException {
        File file = this.version.getMessagesFile();
        if (file == null) {
            return null;
        }
        ArrayList<LogMessage> ret = new ArrayList<LogMessage>();
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            try {
                while (true) {
                    String code = in.readUTF();
                    String level = in.readUTF();
                    String returnType = in.readUTF();
                    String message = in.readUTF();
                    int id = in.readInt();
                    int length = in.readInt();
                    ret.add(new LogMessage(level, code, message, length, id, returnType));
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            return ret;
        }
    }

    private Map<String, Capability> getCapabilityMap(ModelNode fullModel) {
        ModelNode capabilitiesModel = fullModel.get("possible-capabilities");
        TreeMap<String, Capability> capabilityMap = new TreeMap<String, Capability>();
        if (capabilitiesModel.isDefined()) {
            capabilitiesModel.asList().forEach(cap -> {
                Capability capability = Capability.fromModel(cap, Collections.emptyMap(), null);
                capabilityMap.put(capability.getName(), capability);
            });
        }
        return capabilityMap;
    }

    private void createResourcePage(ModelNode model, Template template, boolean hasLogs, PathElement ... path) throws TemplateException, IOException {
        String currentUrl = this.buildCurrentUrl(path);
        String relativePathToContextRoot = SingleVersionGenerator.createRelativePathToContextRoor(currentUrl);
        String currentUrlWithSeparator = currentUrl + (currentUrl.isEmpty() ? "" : "/");
        String productHomeUrl = this.single ? "" : this.version.getProduct() + "/" + this.version.getVersion();
        ResourceDescription resourceDescription = ResourceDescription.fromModelNode(PathAddress.pathAddress(path), model, this.capabilities);
        List<Breadcrumb> crumbs = this.buildBreadcrumbs(path);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("page", RESOURCE_HTML);
        data.put("versions", this.versions);
        data.put("version", this.version);
        data.put("currenturl", currentUrl);
        data.put("currentUrlWithSeparator", currentUrlWithSeparator);
        data.put("relativePathToContextRoot", relativePathToContextRoot);
        data.put("has_messages", hasLogs);
        data.put("globalCapabilities", this.capabilities);
        data.put("productHomeUrl", productHomeUrl);
        data.put("model", resourceDescription);
        data.put("breadcrumbs", crumbs);
        File parent = this.single ? new File(this.outputDir.toFile().getAbsolutePath() + File.separator + currentUrl) : new File(this.outputDir.toFile().getAbsolutePath() + File.separator + this.version.getProduct() + File.separator + this.version.getVersion() + (currentUrl.isEmpty() || currentUrl.startsWith(File.separator) ? "" : File.separator) + currentUrl);
        parent.mkdirs();
        StringWriter stringWriter = new StringWriter();
        template.process(data, stringWriter);
        HtmlCompressor compressor = new HtmlCompressor();
        String compressedHtml = compressor.compress(stringWriter.getBuffer().toString());
        try (FileOutputStream stream = new FileOutputStream(new File(parent, "index.html"));){
            stream.write(compressedHtml.getBytes("UTF-8"));
        }
        if (resourceDescription.getChildren() != null) {
            for (Child child : resourceDescription.getChildren()) {
                if (child.getChildren().isEmpty()) {
                    PathElement[] newPath = this.addToPath(path, child.getName(), "*");
                    ModelNode childModel = model.get("children").get(child.getName());
                    if (!childModel.hasDefined("model-description")) continue;
                    ModelNode newModel = childModel.get("model-description").get("*");
                    if (!newModel.hasDefined("operations")) {
                        newModel.get("operations");
                    }
                    this.createResourcePage(newModel, template, false, newPath);
                    continue;
                }
                for (Child registration : child.getChildren()) {
                    PathElement[] newPath = this.addToPath(path, child.getName(), registration.getName());
                    ModelNode childModel = model.get("children").get(child.getName());
                    if (!childModel.hasDefined("model-description") || !childModel.get("model-description").hasDefined(registration.getName())) continue;
                    ModelNode newModel = childModel.get("model-description").get(registration.getName());
                    this.createResourcePage(newModel, template, false, newPath);
                }
            }
        }
    }

    static String createRelativePathToContextRoor(String relativeUrl) {
        StringBuilder sb = new StringBuilder();
        int length = relativeUrl.isEmpty() ? 0 : relativeUrl.split("/").length;
        for (int i = 0; i < length; ++i) {
            sb.append("../");
        }
        return sb.toString();
    }

    private void createLogMessagePage(Template template, List<LogMessage> messages) throws TemplateException, IOException {
        String productHomeUrl = this.single ? "" : this.version.getProduct() + "/" + this.version.getVersion();
        String currentUrl = this.buildCurrentUrl(new PathElement[0]);
        String currentUrlWithSeparator = currentUrl + (currentUrl.isEmpty() ? "" : "/");
        String relativePathToContextRoot = SingleVersionGenerator.createRelativePathToContextRoor(currentUrl);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("page", LOGS_HTML);
        data.put("versions", this.versions);
        data.put("version", this.version);
        data.put("currentUrl", currentUrl);
        data.put("currentUrlWithSeparator", currentUrlWithSeparator);
        data.put("relativePathToContextRoot", relativePathToContextRoot);
        data.put("globalCapabilities", this.capabilities);
        data.put("productHomeUrl", productHomeUrl);
        data.put("breadcrumbs", this.buildBreadcrumbs(new PathElement[]{PathElement.pathElement("messages")}));
        TreeMap<String, List> map = new TreeMap<String, List>();
        for (LogMessage msg : messages) {
            if (msg.getCode().isEmpty()) continue;
            String realId = msg.getCode() + String.format("%0" + msg.getLength() + "d", msg.getMsgId());
            DisplayMessage d = new DisplayMessage(realId, msg.getMessage(), msg.getLevel(), msg.getMsgId(), msg.returnType.equals("void") ? "" : msg.returnType);
            map.computeIfAbsent(msg.getCode(), i -> new ArrayList()).add(d);
        }
        map.forEach((s, messages1) -> Collections.sort(messages1));
        data.put("messages", map);
        data.put("codes", new ArrayList(map.keySet()));
        File parent = this.single ? new File(this.outputDir.toFile().getAbsolutePath() + File.separator) : new File(this.outputDir.toFile().getAbsolutePath() + File.separator + this.version.getProduct() + File.separator + this.version.getVersion());
        parent.mkdirs();
        StringWriter stringWriter = new StringWriter();
        template.process(data, stringWriter);
        HtmlCompressor compressor = new HtmlCompressor();
        String compressedHtml = compressor.compress(stringWriter.getBuffer().toString());
        try (FileOutputStream stream = new FileOutputStream(new File(parent, LOG_MESSAGE_REFERENCE_HTML));){
            stream.write(compressedHtml.getBytes("UTF-8"));
        }
    }

    private String getUrlBase() {
        if (System.getProperty("url") == null) {
            return this.outputDir.toUri().toString();
        }
        return System.getProperty("url");
    }

    private PathElement[] addToPath(PathElement[] path, String key, String value) {
        PathElement[] newPath = new PathElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = new PathElement(key, value);
        return newPath;
    }

    private List<Breadcrumb> buildBreadcrumbs(PathElement[] path) {
        ArrayList<Breadcrumb> crumbs = new ArrayList<Breadcrumb>();
        if (this.single) {
            crumbs.add(new Breadcrumb("home", "index.html"));
        } else {
            crumbs.add(new Breadcrumb(this.version.getProduct() + " " + this.version.getVersion(), "index.html"));
        }
        StringBuilder currentUrl = new StringBuilder("");
        for (PathElement i : path) {
            if (!currentUrl.toString().isEmpty()) {
                currentUrl.append("/");
            }
            currentUrl.append(i.getKey());
            if (!i.isWildcard()) {
                currentUrl.append("/").append(i.getValue());
            }
            String label = i.getKey() + (String)(i.isWildcard() ? "" : "=" + i.getValue());
            String url = currentUrl.toString();
            crumbs.add(new Breadcrumb(label, url + (url.isEmpty() ? "" : "/") + "index.html"));
        }
        return crumbs;
    }

    private String buildCurrentUrl(PathElement ... path) {
        StringBuilder sb = new StringBuilder();
        for (PathElement i : path) {
            if (!sb.toString().isEmpty()) {
                sb.append('/');
            }
            sb.append(i.getKey());
            if (i.isWildcard()) continue;
            sb.append('/');
            sb.append(i.getValue());
        }
        return sb.toString();
    }

    public class DisplayMessage
    implements Comparable<DisplayMessage> {
        private final String id;
        private final String message;
        private final String level;
        private final int numericId;
        final String returnType;

        public DisplayMessage(String id, String message, String level, int numericId, String returnType) {
            this.id = id;
            this.message = message;
            this.level = level;
            this.numericId = numericId;
            this.returnType = returnType;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLevel() {
            return this.level;
        }

        public String getReturnType() {
            return this.returnType;
        }

        @Override
        public int compareTo(DisplayMessage o) {
            return Integer.compare(this.numericId, o.numericId);
        }
    }

    public static final class LogMessage {
        final String level;
        final String code;
        final String message;
        final int length;
        final int msgId;
        final String returnType;

        private LogMessage(String level, String code, String message, int length, int msgId, String returnType) {
            this.level = level;
            this.code = code;
            this.message = message;
            this.length = length;
            this.msgId = msgId;
            this.returnType = returnType;
        }

        public String getLevel() {
            return this.level;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public int getLength() {
            return this.length;
        }

        public int getMsgId() {
            return this.msgId;
        }

        public String toString() {
            return "LogMessage{level='" + this.level + "', code='" + this.code + "', message='" + this.message + "', length=" + this.length + ", msgId=" + this.msgId + "}";
        }
    }
}

