/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wildscribe.site;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.wildscribe.site.AlertMessage;
import org.jboss.wildscribe.site.SingleVersionGenerator;
import org.jboss.wildscribe.site.Version;

class SiteGenerator {
    private static final Logger LOGGER = Logger.getLogger(SiteGenerator.class.getPackage().getName());
    private static final String DEFAULT_LAYOUT_HTML = "layout.html";
    private static final String SINGLE_LAYOUT_HTML = "single-layout.html";
    public static final String INDEX_HTML = "index.html";
    public static final String ABOUT_HTML = "about.html";
    public static final String RESOURCE_HTML = "resource.html";
    private final List<Version> versions;
    private final Configuration configuration;
    private final Path outputDir;

    public SiteGenerator(List<Version> versions, Configuration configuration, Path outputDir) {
        this.versions = versions;
        this.configuration = configuration;
        this.outputDir = outputDir;
    }

    public void createMainPage() throws IOException, TemplateException {
        Template template = this.configuration.getTemplate(DEFAULT_LAYOUT_HTML);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("page", INDEX_HTML);
        data.put("versions", this.versions);
        data.put("urlbase", this.getUrlBase());
        boolean wf = false;
        boolean eap6 = false;
        boolean as7 = false;
        assert (this.versions != null);
        this.versions.stream().filter(version -> version.getProduct().equals("JBoss EAP")).filter(version -> version.getVersion().startsWith("7")).findFirst().ifPresent(v -> data.put("eap7", v));
        for (Version version2 : this.versions) {
            if (version2.getProduct().equals("JBoss AS7") && !as7) {
                as7 = true;
                data.put("as7", version2);
                continue;
            }
            if (version2.getProduct().equals("JBoss EAP") && !eap6) {
                if (!version2.getVersion().startsWith("6")) continue;
                eap6 = true;
                data.put("eap6", version2);
                continue;
            }
            if (!version2.getProduct().equals("WildFly") || wf) continue;
            wf = true;
            data.put("wildfly", version2);
        }
        String alertMessage = System.getProperty("wildscribe.index.alert.message");
        if (alertMessage != null) {
            AlertMessage am = new AlertMessage();
            String dismissible = System.getProperty("wildscribe.index.alert.dismissible");
            am.setDismissible(dismissible != null && dismissible.isEmpty() || Boolean.parseBoolean(dismissible));
            am.setHeader(System.getProperty("wildscribe.index.alert.header"));
            am.setMessage(alertMessage);
            am.setType(System.getProperty("wildscribe.index.alert.type"));
            data.put("alertMessage", am);
        }
        template.process(data, new PrintWriter(Files.newBufferedWriter(this.outputDir.resolve(INDEX_HTML), StandardCharsets.UTF_8, new OpenOption[0])));
    }

    public void createAboutPage() throws IOException, TemplateException {
        Template template = this.configuration.getTemplate(DEFAULT_LAYOUT_HTML);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("page", ABOUT_HTML);
        data.put("versions", this.versions);
        data.put("urlbase", this.getUrlBase());
        template.process(data, new PrintWriter(Files.newBufferedWriter(this.outputDir.resolve(ABOUT_HTML), StandardCharsets.UTF_8, new OpenOption[0])));
    }

    public void createVersions() throws IOException, TemplateException {
        for (Version version : this.versions) {
            LOGGER.infof("Processing %s %s", (Object)version.getProduct(), (Object)version.getVersion());
            new SingleVersionGenerator(this.versions, version, this.configuration, this.outputDir, DEFAULT_LAYOUT_HTML).generate();
        }
    }

    public void createSingleVersion() throws IOException, TemplateException {
        SingleVersionGenerator gen = new SingleVersionGenerator(null, this.versions.get(0), this.configuration, this.outputDir, SINGLE_LAYOUT_HTML);
        gen.setSingle(true);
        gen.generate();
    }

    private String getUrlBase() {
        if (System.getProperty("url") == null) {
            return this.outputDir.toUri().toString();
        }
        return System.getProperty("url");
    }
}

