/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.stack.cxf.client.HandlerResolverImpl;
import org.jboss.wsf.stack.cxf.client.ServiceRefStubPropertyConfigurer;

public class ServiceObjectFactory
implements ObjectFactory {
    protected final Logger log = Logger.getLogger(ServiceObjectFactory.class);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            void var16_25;
            Class<?> targetClass;
            Reference ref = (Reference)obj;
            String targetClassName = (String)ref.get("TARGET_CLASS_NAME").getContent();
            UnifiedServiceRefMetaData serviceRef = this.unmarshallServiceRef(ref);
            BusFactory.setDefaultBus(null);
            Bus bus = BusFactory.getThreadDefaultBus();
            Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
            bus.setExtension((Object)new ServiceRefStubPropertyConfigurer(serviceRef, configurer), Configurer.class);
            String serviceRefName = serviceRef.getServiceRefName();
            QName serviceQName = serviceRef.getServiceQName();
            String serviceImplClass = serviceRef.getServiceImplClass();
            if (serviceImplClass == null) {
                serviceImplClass = (String)ref.get("SERVICE_CLASS_NAME").getContent();
            }
            if (Service.class.getName().equals(targetClassName)) {
                targetClassName = serviceImplClass;
            }
            this.log.debug((Object)("getObjectInstance [name=" + serviceRefName + ",service=" + serviceImplClass + ",target=" + targetClassName + "]"));
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Class<?> serviceClass = ctxLoader.loadClass(serviceImplClass);
            Class<?> clazz = targetClass = targetClassName != null ? ctxLoader.loadClass(targetClassName) : null;
            if (!Service.class.isAssignableFrom(serviceClass)) {
                throw new IllegalArgumentException("WebServiceRef type '" + serviceClass + "' is not assignable to javax.xml.ws.Service");
            }
            URL wsdlURL = serviceRef.getWsdlLocation();
            if (serviceClass == Service.class) {
                if (wsdlURL == null) throw new IllegalArgumentException("Cannot create generic javax.xml.ws.Service without wsdlLocation: " + serviceRefName);
                Service service = Service.create((URL)wsdlURL, (QName)serviceQName);
            } else if (wsdlURL != null) {
                Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class);
                Object obj2 = ctor.newInstance(wsdlURL, serviceQName);
            } else {
                Service service = (Service)serviceClass.newInstance();
            }
            if (targetClassName != null && !targetClassName.equals(serviceImplClass)) {
                try {
                    Object port = null;
                    if (serviceClass != Service.class) {
                        for (Method method : serviceClass.getDeclaredMethods()) {
                            void var16_21;
                            String methodName = method.getName();
                            Class<?> retType = method.getReturnType();
                            if (!methodName.startsWith("get") || !targetClass.isAssignableFrom(retType)) continue;
                            Object object = port = method.invoke((Object)var16_21, new Object[0]);
                            break;
                        }
                    }
                    if (port == null) {
                        void var16_23;
                        Method method = serviceClass.getMethod("getPort", Class.class);
                        Object object = port = method.invoke((Object)var16_23, targetClass);
                    }
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            if (serviceRef.getHandlerChain() == null || !(var16_25 instanceof Service)) return var16_25;
            ((Service)var16_25).setHandlerResolver((HandlerResolver)new HandlerResolverImpl(bus, serviceRef.getHandlerChain(), var16_25.getClass()));
            return var16_25;
        }
        catch (Throwable ex) {
            WSFException.rethrow((String)"Cannot create service", (Throwable)ex);
            return null;
        }
    }

    private UnifiedServiceRefMetaData unmarshallServiceRef(Reference ref) throws ClassNotFoundException, NamingException {
        UnifiedServiceRefMetaData sref;
        RefAddr refAddr = ref.get("SERVICE_REF_META_DATA");
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])refAddr.getContent());
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
        }
        return sref;
    }
}

