/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class ServiceRefStubPropertyConfigurer
implements Configurer {
    private UnifiedServiceRefMetaData serviceRefMD;
    private Configurer delegate;

    public ServiceRefStubPropertyConfigurer(UnifiedServiceRefMetaData serviceRefMD, Configurer delegate) {
        this.serviceRefMD = serviceRefMD;
        this.delegate = delegate;
    }

    public void configureBean(Object beanInstance) {
        if (this.delegate != null) {
            this.delegate.configureBean(beanInstance);
        }
    }

    public void configureBean(String name, Object beanInstance) {
        if (name != null && beanInstance instanceof JaxWsProxyFactoryBean) {
            QName portQName = null;
            try {
                String portName = name.substring(0, name.indexOf(".jaxws-client.proxyFactory"));
                portQName = QName.valueOf(portName);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to retrieve port QName from '" + name + "', trying matching port using endpoint interface name only."));
            }
            this.configureJaxWsProxyFactoryBean(portQName, (JaxWsProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(name, beanInstance);
        }
    }

    private synchronized void configureJaxWsProxyFactoryBean(QName portQName, JaxWsProxyFactoryBean proxyFactory) {
        Class clazz = proxyFactory.getServiceClass();
        UnifiedPortComponentRefMetaData upcmd = this.serviceRefMD.getPortComponentRef(clazz != null ? clazz.getName() : null, portQName);
        if (upcmd != null) {
            this.setProperties(proxyFactory, upcmd);
        }
    }

    private void setProperties(JaxWsProxyFactoryBean proxyFactory, UnifiedPortComponentRefMetaData upcmd) {
        HashMap<String, String> properties = proxyFactory.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            proxyFactory.setProperties(properties);
        }
        for (UnifiedStubPropertyMetaData prop : upcmd.getStubProperties()) {
            properties.put(prop.getPropName(), prop.getPropValue());
        }
    }
}

