/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import javax.xml.ws.spi.Provider;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.jboss.ws.api.tools.WSContractConsumer;
import org.jboss.ws.common.utils.NullPrintStream;
import org.jboss.wsf.stack.cxf.Messages;

public class CXFConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles = null;
    private File catalog = null;
    private boolean extension;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String targetPackage = null;
    private PrintStream messageStream = null;
    private String wsdlLocation = null;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private boolean additionalHeaders = false;
    private String target;
    private boolean nocompile = false;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(URL wsdl) {
        ArrayList<String> args = new ArrayList<String>();
        PrintStream stream = this.messageStream;
        boolean verbose = false;
        if (stream != null) {
            verbose = true;
        } else {
            stream = NullPrintStream.getInstance();
        }
        if ("2.1".equals(this.target)) {
            args.add("-frontend");
            args.add("jaxws21");
        } else if (this.target != null && !this.target.equals("2.2")) {
            stream.println(Messages.MESSAGES.unsupportedTargetUsingDefault(this.target, "2.2"));
        }
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (!this.nocompile) {
            args.add("-compile");
        }
        args.add("-exsh");
        args.add(this.additionalHeaders ? "true" : "false");
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        File sourceTempDir = null;
        if (this.generateSource) {
            if (this.sourceDir == null) {
                this.sourceDir = this.outputDir;
            }
            if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                throw Messages.MESSAGES.couldNotMakeDirectory(this.sourceDir.getName());
            }
            args.add("-d");
            args.add(this.sourceDir.getAbsolutePath());
        } else {
            sourceTempDir = new File(this.outputDir, "tmp" + Math.round(Math.random() * 1.0E7));
            FileUtils.mkDir((File)sourceTempDir);
            args.add("-d");
            args.add(sourceTempDir.getAbsolutePath());
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdlLocation");
            args.add(this.wsdlLocation);
        }
        if (verbose) {
            args.add("-verbose");
        }
        if (this.extension) {
            stream.println("TODO! Cheek SOAP 1.2 extension");
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw Messages.MESSAGES.couldNotMakeDirectory(this.outputDir.getName());
        }
        if (!this.nocompile) {
            args.add("-classdir");
            args.add(this.outputDir.getAbsolutePath());
        }
        args.add("-allowElementReferences");
        args.add(wsdl.toString());
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuffer javaCP = new StringBuffer();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        WSDLToJava w2j = new WSDLToJava(args.toArray(new String[0]));
        try {
            ToolContext ctx = new ToolContext();
            ctx.put("compiler", (Object)new JBossModulesAwareCompiler());
            w2j.run(ctx, (OutputStream)stream);
        }
        catch (Throwable t) {
            if (this.messageStream != null) {
                this.messageStream.println(Messages.MESSAGES.failedToInvoke(WSDLToJava.class.getName()));
                t.printStackTrace(this.messageStream);
            } else {
                t.printStackTrace();
            }
        }
        finally {
            if (sourceTempDir != null) {
                FileUtils.removeDir((File)sourceTempDir);
            }
        }
    }

    static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    final class JavaFileObjectImpl
    extends SimpleJavaFileObject {
        private ClassLoader loader;
        private final String key;

        JavaFileObjectImpl(String fqClassName, ClassLoader loader) {
            super(CXFConsumerImpl.toURI(fqClassName), JavaFileObject.Kind.CLASS);
            this.loader = loader;
            this.key = "/" + fqClassName.replace(".", "/") + ".class";
        }

        @Override
        public InputStream openInputStream() {
            return this.loader.getResourceAsStream(this.key);
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }
    }

    final class CustomJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private ClassLoader classLoader;

        protected CustomJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
            this.classLoader = Provider.provider().getClass().getClassLoader();
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            return super.getFileForInput(location, packageName, relativeName);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
            String result = file instanceof JavaFileObjectImpl ? file.getName() : super.inferBinaryName(loc, file);
            return result;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
            ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            if (location == StandardLocation.PLATFORM_CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                ArrayList<JavaFileObject> resultFiltered = new ArrayList<JavaFileObject>();
                for (JavaFileObject obj : result) {
                    ClassLoader loader;
                    String objName = obj.getName();
                    Class<?> clazz = null;
                    String className = packageName + "." + objName.substring(0, objName.length() - 6);
                    try {
                        clazz = this.classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                    boolean added = false;
                    if (clazz != null && (loader = clazz.getClassLoader()) != null) {
                        files.add(new JavaFileObjectImpl(className, loader));
                        added = true;
                    }
                    if (added) continue;
                    resultFiltered.add(obj);
                }
                for (JavaFileObject file : resultFiltered) {
                    files.add(file);
                }
            } else {
                for (JavaFileObject file : result) {
                    files.add(file);
                }
            }
            return files;
        }
    }

    private final class JBossModulesAwareCompiler
    extends Compiler {
        private JBossModulesAwareCompiler() {
        }

        protected boolean useJava6Compiler(String[] files) throws Exception {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager stdFileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> fileList = stdFileManager.getJavaFileObjectsFromStrings(Arrays.asList(files));
            CustomJavaFileManager fileManager = new CustomJavaFileManager(stdFileManager);
            ArrayList<String> args = new ArrayList<String>();
            this.addArgs(args);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, args, null, fileList);
            Boolean ret = task.call();
            fileManager.close();
            return ret;
        }
    }
}

