package org.jboss.wsf.stack.cxf.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import jakarta.xml.ws.WebServiceException;
import javax.xml.namespace.QName;
import java.lang.NumberFormatException;
import org.jboss.wsf.spi.deployment.Deployment;
import java.lang.SecurityException;
import java.lang.String;
import java.net.URL;
import javax.management.ObjectName;
import jakarta.servlet.ServletException;
import java.lang.RuntimeException;
import jakarta.xml.soap.SOAPException;
import java.lang.Throwable;
import org.jboss.wsf.spi.WSFException;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import java.io.File;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2025-05-05T18:49:10+0200")
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String couldNotMakeDirectory$str() {
        return "JBWS024000: Could not make directory: %s";
    }
    @Override
    public final IllegalStateException couldNotMakeDirectory(final String dir) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotMakeDirectory$str(), dir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String classNotFound$str() {
        return "JBWS024001: Class not found: %s";
    }
    @Override
    public final IllegalArgumentException classNotFound(final String clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), classNotFound$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToInvoke$str() {
        return "JBWS024002: Failed to invoke %s";
    }
    @Override
    public final String failedToInvoke(final String s) {
        return String.format(getLoggingLocale(), failedToInvoke$str(), s);
    }
    protected String soapMessageCouldNotBeSent$str() {
        return "JBWS024004: SOAP message could not be sent";
    }
    @Override
    public final SOAPException soapMessageCouldNotBeSent(final Throwable cause) {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), soapMessageCouldNotBeSent$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getRequestCouldNotBeSent$str() {
        return "JBWS024005: GET request could not be sent";
    }
    @Override
    public final SOAPException getRequestCouldNotBeSent(final Throwable cause) {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), getRequestCouldNotBeSent$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionAlreadyClosed$str() {
        return "JBWS024006: Connection already closed!";
    }
    @Override
    public final SOAPException connectionAlreadyClosed() {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), connectionAlreadyClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressTypeNotSupported$str() {
        return "JBWS024007: Address object of type %s is not supported";
    }
    @Override
    public final SOAPException addressTypeNotSupported(final Class<?> clazz) {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), addressTypeNotSupported$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConduitInitiatorAvailableFor$str() {
        return "JBWS024008: No ConduitInitiator is available for %s";
    }
    @Override
    public final SOAPException noConduitInitiatorAvailableFor(final String s) {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), noConduitInitiatorAvailableFor$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConduitInitiatorAvailableFor2$str() {
        return "JBWS024009: No ConduitInitiator is available for %s";
    }
    @Override
    public final SOAPException noConduitInitiatorAvailableFor2(final String s, final Throwable cause) {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), noConduitInitiatorAvailableFor2$str(), s), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String soapMessageCouldNotBeRead$str() {
        return "JBWS024010: SOAP message could not be read";
    }
    @Override
    public final SOAPException soapMessageCouldNotBeRead(final Throwable cause) {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), soapMessageCouldNotBeRead$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cantSendMessagesOnClosedConnection$str() {
        return "JBWS024011: Cannot send messages using a previously closed connection";
    }
    @Override
    public final SOAPException cantSendMessagesOnClosedConnection() {
        final SOAPException result = new SOAPException(String.format(getLoggingLocale(), cantSendMessagesOnClosedConnection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMapEndpoin$str() {
        return "JBWS024012: Unsupported MAPEndpoint: %s";
    }
    @Override
    public final IllegalArgumentException unsupportedMapEndpoin(final Object o) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedMapEndpoin$str(), o));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNullEndpointReference$str() {
        return "JBWS024013: Invalid null endpoint reference";
    }
    @Override
    public final IllegalArgumentException invalidNullEndpointReference() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNullEndpointReference$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMap$str() {
        return "JBWS024014: Unsupported MAP: %s";
    }
    @Override
    public final IllegalArgumentException unsupportedMap(final Object o) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedMap$str(), o));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFeature$str() {
        return "JBWS024017: Unknown feature error: %s";
    }
    @Override
    public final WebServiceException unknownFeature(final String f) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), unknownFeature$str(), f));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jaxrpcServiceRefNotSupported$str() {
        return "JBWS024019: Apache CXF does not support JAX-RPC and a JAX-RPC service ref is requested with it; something is likely wrong with the user configuration or classpath";
    }
    @Override
    public final UnsupportedOperationException jaxrpcServiceRefNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), jaxrpcServiceRefNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String handlerConfigFileNotFound$str() {
        return "JBWS024020: Handler config file not found: %s";
    }
    @Override
    public final WebServiceException handlerConfigFileNotFound(final String file) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), handlerConfigFileNotFound$str(), file));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentElementExpected$str() {
        return "JBWS024021: Error parsing %s, %s element expected, but found %s";
    }
    @Override
    public final WebServiceException differentElementExpected(final String file, final String exp, final String found) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), differentElementExpected$str(), file, exp, found));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noHandlerChainFound$str() {
        return "JBWS024022: No handler-chain found while parsing: %s";
    }
    @Override
    public final WebServiceException noHandlerChainFound(final String file, final Throwable cause) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), noHandlerChainFound$str(), file), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElementInHandler$str() {
        return "JBWS024023: Error parsing %s, invalid element in handler: %s";
    }
    @Override
    public final WebServiceException invalidElementInHandler(final String file, final String el) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), invalidElementInHandler$str(), file, el));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAQNamePattern$str() {
        return "JBWS024024: Error parsing %s, %s is not a valid QName pattern";
    }
    @Override
    public final WebServiceException notAQNamePattern(final String file, final String pattern) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), notAQNamePattern$str(), file, pattern));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResolveHandlerFile$str() {
        return "JBWS024025: Cannot resolve handler file %s on %s";
    }
    @Override
    public final WebServiceException cannotResolveHandlerFile(final String file, final String className) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), cannotResolveHandlerFile$str(), file, className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notABusExtensionInstance$str() {
        return "JBWS024026: %s is not a BusExtension instance";
    }
    @Override
    public final RuntimeException notABusExtensionInstance(final Object obj) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), notABusExtensionInstance$str(), obj));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotObtainRegistry$str() {
        return "JBWS024028: Cannot obtain %s";
    }
    @Override
    public final ServletException cannotObtainRegistry(final String registryInterfaceName) {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), cannotObtainRegistry$str(), registryInterfaceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotObtainDestinationFor$str() {
        return "JBWS024029: Cannot obtain destination for %s";
    }
    @Override
    public final ServletException cannotObtainDestinationFor(final String requestURI) {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), cannotObtainDestinationFor$str(), requestURI));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotObtainDestinationFactoryForHttpTransport$str() {
        return "JBWS024030: Cannot obtain destination factory for http transport";
    }
    @Override
    public final ServletException cannotObtainDestinationFactoryForHttpTransport(final Throwable cause) {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), cannotObtainDestinationFactoryForHttpTransport$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotLoadClass$str() {
        return "JBWS024031: Cannot load class %s";
    }
    @Override
    public final IllegalStateException cannotLoadClass(final String clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotLoadClass$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotObtainEndpoint$str() {
        return "JBWS024032: Cannot obtain endpoint %s";
    }
    @Override
    public final WebServiceException cannotObtainEndpoint(final ObjectName on) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), cannotObtainEndpoint$str(), on));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailed$str() {
        return "JBWS024047: Authentication failed, principal=%s";
    }
    @Override
    public final SecurityException authenticationFailed(final String principal) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailed$str(), principal));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestRejectedTimeStamp$str() {
        return "JBWS024048: Request rejected since a stale timestamp has been provided: %s";
    }
    @Override
    public final SecurityException requestRejectedTimeStamp(final String created) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), requestRejectedTimeStamp$str(), created));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestRejectedSameNonce$str() {
        return "JBWS024049: Request rejected since a message with the same nonce has been recently received; nonce = %s";
    }
    @Override
    public final SecurityException requestRejectedSameNonce(final String nonce) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), requestRejectedSameNonce$str(), nonce));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDateTimeFormat$str() {
        return "JBWS024050: DateTime value does not follow the format '[-]yyyy-mm-ddThh:mm:ss[.s+][timezone]': expected 'T' but got %s";
    }
    @Override
    public final IllegalArgumentException invalidDateTimeFormat(final char c) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDateTimeFormat$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDateValueFormat$str() {
        return "JBWS024051: Date value does not follow the format '-'? yyyy '-' mm '-' dd: %s";
    }
    @Override
    public final IllegalArgumentException invalidDateValueFormat(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDateValueFormat$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTimeValueFormat$str() {
        return "JBWS024052: Time value does not follow the format 'hh:mm:ss.[s+]': %s";
    }
    @Override
    public final IllegalArgumentException invalidTimeValueFormat(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTimeValueFormat$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTimeZoneValueFormat$str() {
        return "JBWS024053: Timezone value does not follow the format ([+/-]HH:MM): %s";
    }
    @Override
    public final NumberFormatException invalidTimeZoneValueFormat(final String value) {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), invalidTimeZoneValueFormat$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedTokenType$str() {
        return "JBWS024055: Unsupported token type: %s";
    }
    @Override
    public final SecurityException unsupportedTokenType(final Object tokenType) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unsupportedTokenType$str(), tokenType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotGetSubjectInfo$str() {
        return "JBWS024056: Could not get subject info neither from Security Token in the current message nor directly from computed SecurityContext";
    }
    @Override
    public final SecurityException couldNotGetSubjectInfo() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), couldNotGetSubjectInfo$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailedSubjectNotCreated$str() {
        return "JBWS024057: Failed Authentication : Subject has not been created";
    }
    @Override
    public final SecurityException authenticationFailedSubjectNotCreated(final Throwable cause) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedSubjectNotCreated$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailedSubjectInvalid$str() {
        return "JBWS024058: Failed Authentication : Invalid Subject";
    }
    @Override
    public final SecurityException authenticationFailedSubjectInvalid() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedSubjectInvalid$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String runtimeLoaderCannotBeNull$str() {
        return "JBWS024070: Runtime loader cannot be null; deployment: %s";
    }
    @Override
    public final IllegalStateException runtimeLoaderCannotBeNull(final Deployment dep) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), runtimeLoaderCannotBeNull$str(), dep));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String webserviceAnnotationNotFound$str() {
        return "JBWS024071: @WebService annotation not found on %s";
    }
    @Override
    public final RuntimeException webserviceAnnotationNotFound(final String sei) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), webserviceAnnotationNotFound$str(), sei));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String webserviceAnnotationSEIAttributes$str() {
        return "JBWS024072: @WebService cannot have attribute 'portName', 'serviceName', 'endpointInterface' on %s";
    }
    @Override
    public final RuntimeException webserviceAnnotationSEIAttributes(final String sei) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), webserviceAnnotationSEIAttributes$str(), sei));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wsdl20NotSupported$str() {
        return "JBWS024075: WSDL 2.0 not supported";
    }
    @Override
    public final RuntimeException wsdl20NotSupported() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), wsdl20NotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotPublishWSDLTo$str() {
        return "JBWS024076: Service %s, cannot publish wsdl to: %s";
    }
    @Override
    public final RuntimeException cannotPublishWSDLTo(final QName serviceName, final File file, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotPublishWSDLTo$str(), serviceName, file), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String endpointNotDefineInJbwsCxf$str() {
        return "JBWS024083: Endpoint %s is not defined in jbossws-cxf.xml";
    }
    @Override
    public final IllegalStateException endpointNotDefineInJbwsCxf(final String ep) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), endpointNotDefineInJbwsCxf$str(), ep));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String busAlreadyConfigured$str() {
        return "JBWS024084: Underlying bus is already configured for JBossWS use: %s";
    }
    @Override
    public final IllegalStateException busAlreadyConfigured(final Object ctx) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), busAlreadyConfigured$str(), ctx));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadConfigurationFrom$str() {
        return "JBWS024085: Unable to load configuration from %s";
    }
    @Override
    public final RuntimeException unableToLoadConfigurationFrom(final URL url, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToLoadConfigurationFrom$str(), url), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadAdditionalConfigFromNull$str() {
        return "JBWS024088: Cannot load additional config from null location";
    }
    @Override
    public final IllegalArgumentException unableToLoadAdditionalConfigFromNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToLoadAdditionalConfigFromNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorParsingPolicyAttachment$str() {
        return "JBWS024093: Error parsing policy attachment: %s";
    }
    @Override
    public final RuntimeException errorParsingPolicyAttachment(final String uri, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorParsingPolicyAttachment$str(), uri), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authorizationFailed$str() {
        return "JBWS024094: Authorization failed, principal=%s";
    }
    @Override
    public final SecurityException authorizationFailed(final String principal) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authorizationFailed$str(), principal));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleJAXWSClientBusFeatureProvided$str() {
        return "JBWS024096: Multiple incompatible JAXWS client Bus features provided";
    }
    @Override
    public final IllegalArgumentException incompatibleJAXWSClientBusFeatureProvided() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), incompatibleJAXWSClientBusFeatureProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingJAXWS22ServiceConstructor$str() {
        return "JBWS024104: Service class %s is missing required JAX-WS 2.2 additional constructors";
    }
    @Override
    public final WSFException missingJAXWS22ServiceConstructor(final String className, final Throwable cause) {
        final WSFException result = new WSFException(String.format(getLoggingLocale(), missingJAXWS22ServiceConstructor$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBindingOpeartionAndDispatchedMethod$str() {
        return "JBWS024108: Invalid request received:bindingOperation and dispatched method are missing for service implementation invocation";
    }
    @Override
    public final IllegalArgumentException missingBindingOpeartionAndDispatchedMethod() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingBindingOpeartionAndDispatchedMethod$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotFetchWSDLContract$str() {
        return "JBWS024109: Could not get WSDL contract for endpoint %s at %s";
    }
    @Override
    public final WSFException couldNotFetchWSDLContract(final String endpoint, final String wsdlLocation) {
        final WSFException result = new WSFException(String.format(getLoggingLocale(), couldNotFetchWSDLContract$str(), endpoint, wsdlLocation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEndpointURI$str() {
        return "JBWS024113: Invalid endpoint URI: %s";
    }
    @Override
    public final IllegalArgumentException invalidEndpointURI(final String endpoint) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEndpointURI$str(), endpoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBindingOperationForAuthorization$str() {
        return "JBWS024118: BindingOperation is missing for authorization";
    }
    @Override
    public final IllegalArgumentException missingBindingOperationForAuthorization() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingBindingOperationForAuthorization$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
