/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import jakarta.xml.ws.handler.LogicalHandler;
import jakarta.xml.ws.handler.MessageContext;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.stack.cxf.client.SecurityActions;

final class TCCLAwareLogicalHandler
implements LogicalHandler {
    private final LogicalHandler delegate;

    TCCLAwareLogicalHandler(LogicalHandler delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(MessageContext messageContext) {
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            if (original instanceof DelegateClassLoader) {
                DelegateClassLoader delegateCL = (DelegateClassLoader)original;
                SecurityActions.setContextClassLoader(delegateCL.getDelegate());
            }
            boolean bl = this.delegate.handleMessage(messageContext);
            return bl;
        }
        finally {
            SecurityActions.setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleFault(MessageContext messageContext) {
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            if (original instanceof DelegateClassLoader) {
                DelegateClassLoader delegateCL = (DelegateClassLoader)original;
                SecurityActions.setContextClassLoader(delegateCL.getDelegate());
            }
            boolean bl = this.delegate.handleFault(messageContext);
            return bl;
        }
        finally {
            SecurityActions.setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(MessageContext messageContext) {
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            if (original instanceof DelegateClassLoader) {
                DelegateClassLoader delegateCL = (DelegateClassLoader)original;
                SecurityActions.setContextClassLoader(delegateCL.getDelegate());
            }
            this.delegate.close(messageContext);
        }
        finally {
            SecurityActions.setContextClassLoader(original);
        }
    }
}

