/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.tx.InfinispanXAResourceRecovery;
import org.jboss.as.clustering.infinispan.tx.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.tx.TransactionSynchronizationRegistryProvider;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionResourceDefinition
extends ComponentResourceDefinition {
    static final PathElement PATH = TransactionResourceDefinition.pathElement("transaction");
    static final BinaryServiceDescriptor<TransactionConfiguration> SERVICE_DESCRIPTOR = TransactionResourceDefinition.serviceDescriptor(PATH, TransactionConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).build();
    static final NullaryServiceDescriptor<Void> LOCAL_TRANSACTION_PROVIDER = NullaryServiceDescriptor.of((String)"org.wildfly.transactions.global-default-local-provider", Void.class);
    static final NullaryServiceDescriptor<TransactionSynchronizationRegistry> TRANSACTION_SYNCHRONIZATION_REGISTRY = NullaryServiceDescriptor.of((String)"org.wildfly.transactions.transaction-synchronization-registry", TransactionSynchronizationRegistry.class);
    static final NullaryServiceDescriptor<XAResourceRecoveryRegistry> XA_RESOURCE_RECOVERY_REGISTRY = NullaryServiceDescriptor.of((String)"org.wildfly.transactions.xa-resource-recovery-registry", XAResourceRecoveryRegistry.class);

    TransactionResourceDefinition() {
        super(PATH);
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(CAPABILITY)).addResourceCapabilityReference((CapabilityReferenceRecorder)ResourceCapabilityReference.builder(CAPABILITY, LOCAL_TRANSACTION_PROVIDER).when(Attribute.MODE.getDefinition(), (Predicate)new TransactionModeFilter(EnumSet.complementOf(EnumSet.of(TransactionMode.NONE, TransactionMode.BATCH)))).build()).addResourceCapabilityReference((CapabilityReferenceRecorder)ResourceCapabilityReference.builder(CAPABILITY, TRANSACTION_SYNCHRONIZATION_REGISTRY).when(Attribute.MODE.getDefinition(), (Predicate)new TransactionModeFilter(EnumSet.of(TransactionMode.NON_XA))).build()).addResourceCapabilityReference((CapabilityReferenceRecorder)ResourceCapabilityReference.builder(CAPABILITY, XA_RESOURCE_RECOVERY_REGISTRY).when(Attribute.MODE.getDefinition(), (Predicate)new TransactionModeFilter(EnumSet.of(TransactionMode.FULL_XA))).build());
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final TransactionMode mode = TransactionMode.valueOf(Attribute.MODE.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final LockingMode locking = LockingMode.valueOf((String)Attribute.LOCKING.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final long stopTimeout = Attribute.STOP_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        final long transactionTimeout = Attribute.COMPLETE_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        ServiceDependency dependency = !EnumSet.of(TransactionMode.NONE, TransactionMode.BATCH).contains((Object)mode) ? ServiceDependency.on(LOCAL_TRANSACTION_PROVIDER) : ServiceDependency.of(null);
        final ServiceDependency tsr = mode == TransactionMode.NON_XA ? ServiceDependency.on(TRANSACTION_SYNCHRONIZATION_REGISTRY) : ServiceDependency.of(null);
        Supplier<TransactionConfiguration> configurationFactory = new Supplier<TransactionConfiguration>(){

            @Override
            public TransactionConfiguration get() {
                TransactionConfigurationBuilder builder = new ConfigurationBuilder().transaction().lockingMode(locking).cacheStopTimeout(stopTimeout).completedTxTimeout(transactionTimeout).transactionMode(mode == TransactionMode.NONE ? org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL : org.infinispan.transaction.TransactionMode.TRANSACTIONAL).useSynchronization(mode == TransactionMode.NON_XA).recovery().enabled(mode == TransactionMode.FULL_XA).transaction();
                switch (mode) {
                    case NONE: {
                        break;
                    }
                    case BATCH: {
                        builder.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider((TransactionManager)EmbeddedTransactionManager.getInstance()));
                        break;
                    }
                    case NON_XA: {
                        builder.transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider((TransactionSynchronizationRegistry)tsr.get()));
                    }
                    default: {
                        builder.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider((TransactionManager)ContextTransactionManager.getInstance()));
                    }
                }
                return builder.create();
            }
        };
        ArrayList<ResourceServiceInstaller> installers = new ArrayList<ResourceServiceInstaller>(2);
        installers.add((ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)configurationFactory).requires(List.of(dependency, tsr))).build());
        if (mode == TransactionMode.FULL_XA) {
            PathAddress cacheAddress = context.getCurrentAddress().getParent();
            String containerName = cacheAddress.getParent().getLastElement().getValue();
            String cacheName = cacheAddress.getLastElement().getValue();
            final ServiceDependency recoveryRegistry = ServiceDependency.on(XA_RESOURCE_RECOVERY_REGISTRY);
            ServiceDependency recovery = ServiceDependency.on((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE, (String)containerName, (String)cacheName).map(InfinispanXAResourceRecovery::new);
            Consumer<XAResourceRecovery> start = new Consumer<XAResourceRecovery>(){

                @Override
                public void accept(XAResourceRecovery recovery) {
                    ((XAResourceRecoveryRegistry)recoveryRegistry.get()).addXAResourceRecovery(recovery);
                }
            };
            Consumer<XAResourceRecovery> stop = new Consumer<XAResourceRecovery>(){

                @Override
                public void accept(XAResourceRecovery recovery) {
                    ((XAResourceRecoveryRegistry)recoveryRegistry.get()).removeXAResourceRecovery(recovery);
                }
            };
            installers.add((ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)recovery).onStart((Consumer)start)).onStop((Consumer)stop)).requires(List.of(recoveryRegistry))).build());
        }
        return ResourceServiceInstaller.combine(installers);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        LOCKING("locking", ModelType.STRING, new ModelNode(LockingMode.PESSIMISTIC.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)EnumValidator.create(LockingMode.class));
            }
        }
        ,
        MODE("mode", ModelType.STRING, new ModelNode(TransactionMode.NONE.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)EnumValidator.create(TransactionMode.class));
            }
        }
        ,
        STOP_TIMEOUT("stop-timeout", ModelType.LONG, new ModelNode(TimeUnit.SECONDS.toMillis(10L))){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        }
        ,
        COMPLETE_TIMEOUT("complete-timeout", ModelType.LONG, new ModelNode(TimeUnit.SECONDS.toMillis(60L))){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        };

        private final SimpleAttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    private static class TransactionModeFilter
    implements Predicate<ModelNode> {
        private final Set<TransactionMode> modes;

        TransactionModeFilter(Set<TransactionMode> modes) {
            this.modes = modes;
        }

        @Override
        public boolean test(ModelNode value) {
            try {
                TransactionMode mode = TransactionMode.valueOf(value.asString());
                return this.modes.contains((Object)mode);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
    }
}

