/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ModulesServiceConfigurator;
import org.jboss.as.clustering.controller.PropertiesAttributeDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.remote.ClientThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.ConnectionPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodMarshallerFactory;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerConfigurationServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteClusterResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.SecurityResourceDefinition;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public class RemoteCacheContainerResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    public static final PathElement WILDCARD_PATH = RemoteCacheContainerResourceDefinition.pathElement("*");
    static final RuntimeCapability<Void> REMOTE_CACHE_CONTAINER = RuntimeCapability.Builder.of((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER).build();
    static final RuntimeCapability<Void> REMOTE_CACHE_CONTAINER_CONFIGURATION = RuntimeCapability.Builder.of((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER_CONFIGURATION).build();
    private static final RuntimeCapability<Void> REMOTE_CACHE_CONTAINER_MODULES = RuntimeCapability.Builder.of((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER_MODULES).build();
    public static final Set<PathElement> REQUIRED_CHILDREN = Stream.concat(Set.of(SecurityResourceDefinition.PATH).stream(), EnumSet.allOf(ClientThreadPoolResourceDefinition.class).stream().map(ClientThreadPoolResourceDefinition::getPathElement)).collect(Collectors.toSet());
    private final ServiceValueExecutorRegistry<RemoteCacheContainer> registry = ServiceValueExecutorRegistry.newInstance();

    public static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"remote-cache-container", (String)containerName);
    }

    public RemoteCacheContainerResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(ListAttribute.class).addAttributes(DeprecatedAttribute.class).addCapabilities(List.of(REMOTE_CACHE_CONTAINER, REMOTE_CACHE_CONTAINER_CONFIGURATION, REMOTE_CACHE_CONTAINER_MODULES)).addRequiredChildren(REQUIRED_CHILDREN).setResourceTransformation(RemoteCacheContainerResource::new);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new ConnectionPoolResourceDefinition().register(registration);
        new RemoteClusterResourceDefinition((FunctionExecutorRegistry<RemoteCacheContainer>)this.registry).register(registration);
        new SecurityResourceDefinition().register(registration);
        for (ClientThreadPoolResourceDefinition pool : EnumSet.allOf(ClientThreadPoolResourceDefinition.class)) {
            pool.register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new RemoteCacheContainerMetricExecutor((FunctionExecutorRegistry<RemoteCacheContainer>)this.registry), RemoteCacheContainerMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
            new RemoteCacheResourceDefinition((FunctionExecutorRegistry<RemoteCacheContainer>)this.registry).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        Module defaultModule = Module.forClass(RemoteCacheContainer.class);
        ResourceServiceInstaller modulesInstaller = new ModulesServiceConfigurator(REMOTE_CACHE_CONTAINER_MODULES, ListAttribute.MODULES.getDefinition(), List.of(defaultModule)).configure(context, model);
        ServiceInstaller captureInstaller = this.registry.capture(ServiceDependency.on((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER, (String)name));
        ResourceServiceInstaller configurationInstaller = RemoteCacheContainerConfigurationServiceConfigurator.INSTANCE.configure(context, model);
        ResourceServiceInstaller containerInstaller = RemoteCacheContainerServiceConfigurator.INSTANCE.configure(context, model);
        BinderServiceInstaller bindingInstaller = new BinderServiceInstaller(InfinispanBindingFactory.createRemoteCacheContainerBinding(name), context.getCapabilityServiceName(HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER, name));
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{modulesInstaller, captureInstaller, configurationInstaller, containerInstaller, bindingInstaller});
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        CONNECTION_TIMEOUT("connection-timeout", ModelType.INT, new ModelNode(60000)),
        DEFAULT_REMOTE_CLUSTER("default-remote-cluster", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setCapabilityReference((CapabilityReferenceRecorder)CapabilityReference.builder(REMOTE_CACHE_CONTAINER_CONFIGURATION, RemoteClusterResourceDefinition.SERVICE_DESCRIPTOR).withParentPath(WILDCARD_PATH).build());
            }
        }
        ,
        MARSHALLER("marshaller", ModelType.STRING, new ModelNode(HotRodMarshallerFactory.LEGACY.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator(new ParameterValidator(){
                    private final ParameterValidator validator = EnumValidator.create(HotRodMarshallerFactory.class);

                    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                        this.validator.validateParameter(parameterName, value);
                        if (!value.isDefined() || value.equals(MARSHALLER.getDefinition().getDefaultValue())) {
                            InfinispanLogger.ROOT_LOGGER.marshallerEnumValueDeprecated(parameterName, HotRodMarshallerFactory.LEGACY, EnumSet.complementOf(EnumSet.of(HotRodMarshallerFactory.LEGACY)));
                        }
                    }
                });
            }
        }
        ,
        MAX_RETRIES("max-retries", ModelType.INT, new ModelNode(10)),
        PROPERTIES("properties"),
        PROTOCOL_VERSION("protocol-version", ModelType.STRING, new ModelNode(ProtocolVersion.PROTOCOL_VERSION_41.toString())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(ProtocolVersion.class, EnumSet.complementOf(EnumSet.of(ProtocolVersion.PROTOCOL_VERSION_AUTO))));
            }
        }
        ,
        SOCKET_TIMEOUT("socket-timeout", ModelType.INT, new ModelNode(60000)),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN, ModelNode.FALSE),
        TCP_NO_DELAY("tcp-no-delay", ModelType.BOOLEAN, ModelNode.TRUE),
        TCP_KEEP_ALIVE("tcp-keep-alive", ModelType.BOOLEAN, ModelNode.FALSE),
        TRANSACTION_TIMEOUT("transaction-timeout", ModelType.LONG, new ModelNode(TimeUnit.MINUTES.toMillis(1L))){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name) {
            this.definition = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder(name).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(defaultValue == null)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<StringListAttributeDefinition.Builder>
    {
        MODULES("modules"){

            @Override
            public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
                return (StringListAttributeDefinition.Builder)builder.setElementValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        };

        private final AttributeDefinition definition;

        private ListAttribute(String name) {
            this.definition = this.apply((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
            return builder;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        KEY_SIZE_ESTIMATE("key-size-estimate", ModelType.INT, InfinispanSubsystemModel.VERSION_15_0_0){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(64));
            }
        }
        ,
        VALUE_SIZE_ESTIMATE("value-size-estimate", ModelType.INT, InfinispanSubsystemModel.VERSION_15_0_0){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(512));
            }
        };

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, InfinispanSubsystemModel deprecation) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

