/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.HostControllerUpdateTask;
import org.jboss.as.domain.controller.operations.coordination.MultiPhaseLocalContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class MultiphaseOverallContext {
    private final LocalHostControllerInfo localHostInfo;
    private final MultiPhaseLocalContext localContext = new MultiPhaseLocalContext(true);
    private final ConcurrentMap<String, ModelNode> hostControllerPreparedResults = new ConcurrentHashMap<String, ModelNode>();
    private final ConcurrentMap<String, ModelNode> hostControllerFinalResults = new ConcurrentHashMap<String, ModelNode>();
    private final ConcurrentMap<ServerIdentity, ModelNode> serverResults = new ConcurrentHashMap<ServerIdentity, ModelNode>();
    private final ConcurrentMap<String, HostControllerUpdateTask.ExecutedHostRequest> finalResultFutures = new ConcurrentHashMap<String, HostControllerUpdateTask.ExecutedHostRequest>();
    private final Map<String, Boolean> serverGroupStatuses = new ConcurrentHashMap<String, Boolean>();
    private volatile boolean completeRollback = true;
    private volatile boolean failureReported;

    MultiphaseOverallContext(LocalHostControllerInfo localHostInfo) {
        this.localHostInfo = localHostInfo;
    }

    LocalHostControllerInfo getLocalHostInfo() {
        return this.localHostInfo;
    }

    MultiPhaseLocalContext getLocalContext() {
        return this.localContext;
    }

    Map<String, ModelNode> getHostControllerPreparedResults() {
        return new HashMap<String, ModelNode>(this.hostControllerPreparedResults);
    }

    void addHostControllerPreparedResult(String hostId, ModelNode hostResult) {
        this.hostControllerPreparedResults.put(hostId, hostResult);
    }

    Map<String, ModelNode> getHostControllerFinalResults() {
        return new HashMap<String, ModelNode>(this.hostControllerFinalResults);
    }

    void addHostControllerFinalResult(String hostId, ModelNode hostResult) {
        this.hostControllerFinalResults.put(hostId, hostResult);
    }

    Map<ServerIdentity, ModelNode> getServerResults() {
        return new HashMap<ServerIdentity, ModelNode>(this.serverResults);
    }

    void addServerResult(ServerIdentity serverId, ModelNode serverResult) {
        this.serverResults.put(serverId, serverResult);
    }

    boolean isCompleteRollback() {
        return this.completeRollback;
    }

    public void setCompleteRollback(boolean completeRollback) {
        this.completeRollback = completeRollback;
    }

    boolean isServerGroupRollback(String serverGroup) {
        Boolean ok = this.serverGroupStatuses.get(serverGroup);
        return ok == null || ok != false;
    }

    public void setServerGroupRollback(String serverGroup, boolean rollback) {
        this.serverGroupStatuses.put(serverGroup, rollback);
    }

    public boolean hasHostLevelFailures() {
        boolean domainFailed;
        ModelNode coordinatorResult = this.localContext.getLocalResponse();
        boolean bl = domainFailed = coordinatorResult.isDefined() && coordinatorResult.has("failure-description");
        if (domainFailed) {
            return true;
        }
        for (ModelNode hostResult : this.hostControllerPreparedResults.values()) {
            if (!hostResult.has("failure-description")) continue;
            return true;
        }
        return false;
    }

    public boolean isFailureReported() {
        return this.failureReported;
    }

    public void setFailureReported(boolean failureReported) {
        this.failureReported = failureReported;
    }

    public ModelNode getServerResult(String hostName, String serverName, String ... stepLabels) {
        ModelNode result;
        ServerIdentity id = new ServerIdentity(hostName, null, serverName);
        ModelNode serverResult = this.getServerResults().get(id);
        if (serverResult == null) {
            return null;
        }
        serverResult = serverResult.clone();
        if (stepLabels.length == 0) {
            result = serverResult;
        } else {
            ModelNode hostResults;
            result = new ModelNode();
            if (hostName.equals(this.localHostInfo.getLocalHostName())) {
                hostResults = new ModelNode();
                hostResults.get(new String[]{"result", "server-operations"}).set(this.localContext.getLocalServerOps());
            } else {
                hostResults = (ModelNode)this.hostControllerPreparedResults.get(hostName);
            }
            String[] translatedSteps = this.getTranslatedSteps(serverName, hostResults, stepLabels);
            if (translatedSteps != null && serverResult.hasDefined(translatedSteps)) {
                if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Translated steps for %s/%s[%s] are %s", new Object[]{hostName, serverName, Arrays.asList(stepLabels), Arrays.asList(translatedSteps)});
                }
                result.set(serverResult.get(translatedSteps));
            }
        }
        return result;
    }

    public OperationTransformer.TransformedOperation transformServerOperation(String hostName, TransformingProxyController remoteProxyController, Transformers.TransformationInputs transformationInputs, ModelNode original) throws OperationFailedException {
        final OperationTransformer.TransformedOperation transformed = remoteProxyController.transformOperation(transformationInputs, original);
        final HostControllerUpdateTask.ExecutedHostRequest hostRequest = (HostControllerUpdateTask.ExecutedHostRequest)this.finalResultFutures.get(hostName);
        if (hostRequest == null) {
            return transformed;
        }
        return new OperationTransformer.TransformedOperation(transformed.getTransformedOperation(), new OperationResultTransformer(){

            public ModelNode transformResult(ModelNode result) {
                ModelNode step1 = transformed.transformResult(result);
                return hostRequest.transformResult(step1);
            }
        });
    }

    protected void recordHostRequest(String hostName, HostControllerUpdateTask.ExecutedHostRequest request) {
        this.finalResultFutures.put(hostName, request);
    }

    private String[] getTranslatedSteps(String serverName, ModelNode hostResults, String[] stepLabels) {
        String[] result = null;
        ModelNode domainMappedOp = this.getDomainMappedOperation(serverName, hostResults);
        if (domainMappedOp != null) {
            result = new String[stepLabels.length * 2];
            ModelNode level = domainMappedOp;
            for (int i = 0; i < stepLabels.length; ++i) {
                String translated = this.getTranslatedStepIndex(stepLabels[i], level);
                if (translated == null) {
                    return null;
                }
                result[i * 2] = "result";
                result[i * 2 + 1] = translated;
                level = level.get(stepLabels[i]);
            }
        }
        return result;
    }

    private String getTranslatedStepIndex(String stepLabel, ModelNode level) {
        int i = 1;
        for (String key : level.keys()) {
            if (stepLabel.equals(key)) {
                return "step-" + i;
            }
            ++i;
        }
        return null;
    }

    private ModelNode getDomainMappedOperation(String serverName, ModelNode hostResults) {
        for (ModelNode set : hostResults.get(new String[]{"result", "server-operations"}).asList()) {
            for (Property prop : set.get("servers").asPropertyList()) {
                if (!prop.getName().equals(serverName)) continue;
                return set.get("operation");
            }
        }
        return null;
    }
}

