/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.authz.SourceAddressRoleDecoder;

class RoleDecoderDefinitions {
    static final SimpleAttributeDefinition ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("attribute", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SOURCE_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("source-address", ModelType.STRING).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).setAlternatives(new String[]{"pattern"})).build();
    static final SimpleAttributeDefinition PATTERN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(RegexAttributeDefinitions.PATTERN).setRestartAllServices()).setAlternatives(new String[]{"source-address"})).build();
    static final StringListAttributeDefinition ROLES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("roles").setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    private static final AggregateComponentDefinition<RoleDecoder> AGGREGATE_ROLE_DECODER = AggregateComponentDefinition.create(RoleDecoder.class, "aggregate-role-decoder", "role-decoders", Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY, r -> RoleDecoder.aggregate((RoleDecoder[])r));

    RoleDecoderDefinitions() {
    }

    static ResourceDefinition getSimpleRoleDecoderDefinition() {
        return new SimpleRoleDecoderDefinition();
    }

    static ResourceDefinition getSourceAddressRoleDecoderDefinition() {
        return new SourceAddressRoleDecoderDefinition();
    }

    static AggregateComponentDefinition<RoleDecoder> getAggregateRoleDecoderDefinition() {
        return AGGREGATE_ROLE_DECODER;
    }

    private static class SourceAddressRoleDecoderAddHandler
    extends BaseAddHandler {
        private SourceAddressRoleDecoderAddHandler() {
            super(Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName roleDecoderName = runtimeCapability.getCapabilityServiceName(RoleDecoder.class);
            String sourceAddress = SOURCE_ADDRESS.resolveModelAttribute(context, model).asStringOrNull();
            String pattern = PATTERN.resolveModelAttribute(context, model).asStringOrNull();
            List roles = ROLES.unwrap((ExpressionResolver)context, model);
            TrivialService<RoleDecoder> roleDecoderService = sourceAddress != null ? new TrivialService<RoleDecoder>(() -> new SourceAddressRoleDecoder(sourceAddress, Roles.fromSet(new HashSet(roles)))) : new TrivialService<RoleDecoder>(() -> new SourceAddressRoleDecoder(Pattern.compile(pattern), Roles.fromSet(new HashSet(roles))));
            ServiceBuilder roleDecoderBuilderBuilder = serviceTarget.addService(roleDecoderName, roleDecoderService);
            ElytronDefinition.commonDependencies(roleDecoderBuilderBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class SourceAddressRoleDecoderDefinition
    extends SimpleResourceDefinition {
        private static final AbstractAddStepHandler ADD = new SourceAddressRoleDecoderAddHandler();
        private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY);
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SOURCE_ADDRESS, PATTERN, ROLES};

        SourceAddressRoleDecoderDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"source-address-role-decoder"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("source-address-role-decoder")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            for (AttributeDefinition attributeDefinition : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(attributeDefinition, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
            }
        }
    }

    private static class SimpleRoleDecoderAddHandler
    extends BaseAddHandler {
        private SimpleRoleDecoderAddHandler() {
            super(Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName roleDecoderName = runtimeCapability.getCapabilityServiceName(RoleDecoder.class);
            String attribute = ATTRIBUTE.resolveModelAttribute(context, model).asString();
            TrivialService<RoleDecoder> roleDecoderService = new TrivialService<RoleDecoder>(() -> RoleDecoder.simple((String)attribute));
            ServiceBuilder roleDecoderBuilderBuilder = serviceTarget.addService(roleDecoderName, roleDecoderService);
            ElytronDefinition.commonDependencies(roleDecoderBuilderBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class SimpleRoleDecoderDefinition
    extends SimpleResourceDefinition {
        private static final AbstractAddStepHandler ADD = new SimpleRoleDecoderAddHandler();
        private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY);

        SimpleRoleDecoderDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"simple-role-decoder"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("simple-role-decoder")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.ROLE_DECODER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ATTRIBUTE, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
        }
    }
}

