/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.Jackson2Annotations;
import org.jboss.as.jaxrs.JacksonAnnotations;
import org.jboss.as.jaxrs.JaxrsServerConfig;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.jaxrs.deployment.WildFlyConfigurationFactory;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaxrsIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String JAX_RS_SERVLET_NAME = "jakarta.ws.rs.core.Application";
    private static final String SERVLET_INIT_PARAM = "jakarta.ws.rs.Application";
    private final JaxrsServerConfig contextConfiguration;

    public JaxrsIntegrationProcessor(JaxrsServerConfig contextConfiguration) {
        this.contextConfiguration = contextConfiguration;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String value2;
        String providers;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData webdata = warMetaData.getMergedJBossWebMetaData();
        this.contextConfiguration.getContextParameters().forEach((key, value) -> JaxrsIntegrationProcessor.setContextParameter(webdata, key, value));
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module != null) {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            WildFlyConfigurationFactory configurationFactory = WildFlyConfigurationFactory.getInstance();
            configurationFactory.register((ClassLoader)module.getClassLoader(), JaxrsIntegrationProcessor.useMicroProfileConfig(module, support));
        }
        List params = webdata.getContextParams();
        boolean entityExpandEnabled = false;
        if (params != null) {
            for (ParamValueMetaData param : params) {
                if (!param.getParamName().equals("resteasy.document.expand.entity.references")) continue;
                entityExpandEnabled = true;
            }
        }
        if (!entityExpandEnabled) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.document.expand.entity.references", "false");
        }
        Map attachmentMap = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA);
        ArrayList<ResteasyDeploymentData> additionalData = new ArrayList<ResteasyDeploymentData>();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpec != null && attachmentMap != null) {
            HashSet<String> identifiers = new HashSet<String>();
            for (ModuleDependency dep : moduleSpec.getAllDependencies()) {
                if (identifiers.contains(dep.getDependencyModule())) continue;
                identifiers.add(dep.getDependencyModule());
                if (!attachmentMap.containsKey(dep.getDependencyModule())) continue;
                additionalData.add((ResteasyDeploymentData)attachmentMap.get(dep.getDependencyModule()));
            }
            resteasy.merge(additionalData);
        }
        if (!resteasy.getScannedResourceClasses().isEmpty()) {
            String resources = String.join((CharSequence)",", resteasy.getScannedResourceClasses());
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding Jakarta RESTful Web Services resource classes: %s", resources);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.resources", resources);
        }
        if (!resteasy.getScannedProviderClasses().isEmpty()) {
            providers = String.join((CharSequence)",", resteasy.getScannedProviderClasses());
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding Jakarta RESTful Web Services provider classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.providers", providers);
        }
        if (!resteasy.getScannedJndiComponentResources().isEmpty()) {
            providers = String.join((CharSequence)",", resteasy.getScannedJndiComponentResources());
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding Jakarta RESTful Web Services jndi component resource classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.jndi.resources", providers);
        }
        if (!resteasy.isUnwrappedExceptionsParameterSet()) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.unwrapped.exceptions", "jakarta.ejb.EJBException");
        }
        if (JaxrsIntegrationProcessor.findContextParam(webdata, "resteasy.preferJacksonOverJsonB") == null) {
            String prop = WildFlySecurityManager.getPropertyPrivileged((String)"resteasy.preferJacksonOverJsonB", null);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.preferJacksonOverJsonB", Objects.requireNonNullElseGet(prop, () -> Boolean.toString(this.hasJacksonAnnotations(deploymentUnit))));
        }
        boolean managementAdded = false;
        if (!resteasy.getScannedApplicationClasses().isEmpty() || resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            this.addManagement(deploymentUnit, resteasy);
            managementAdded = true;
        }
        if ((value2 = (String)webdata.getContextParams().stream().filter(contextValue -> "resteasy.server.tracing.type".equals(contextValue.getParamName())).map(ParamValueMetaData::getParamValue).findFirst().orElse(null)) != null && !"OFF".equals(value2)) {
            JaxrsLogger.JAXRS_LOGGER.tracingEnabled(deploymentUnit.getName());
        }
        if (resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            return;
        }
        HashSet<Class<? extends Application>> applicationClassSet = new HashSet<Class<? extends Application>>();
        for (Class<? extends Application> clazz : resteasy.getScannedApplicationClasses()) {
            if (!clazz.isAnnotationPresent(ApplicationPath.class) && !JaxrsIntegrationProcessor.servletMappingsExist(webdata, clazz.getName())) continue;
            applicationClassSet.add(clazz);
        }
        if (applicationClassSet.isEmpty()) {
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setName(JAX_RS_SERVLET_NAME);
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            this.addServlet(webdata, servlet);
            this.setServletMappingPrefix(webdata, JAX_RS_SERVLET_NAME, servlet);
        } else {
            for (Class<Object> clazz : applicationClassSet) {
                String servletName = clazz.getName();
                JBossServletMetaData servlet = new JBossServletMetaData();
                servlet.setLoadOnStartup("0");
                servlet.setName(servletName);
                servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
                servlet.setAsyncSupported(true);
                this.setServletInitParam(servlet, SERVLET_INIT_PARAM, clazz.getName());
                this.addServlet(webdata, servlet);
                if (!JaxrsIntegrationProcessor.servletMappingsExist(webdata, servletName)) {
                    ArrayList<Object> patterns = new ArrayList<Object>();
                    Object pathValue = URLDecoder.decode(clazz.getAnnotation(ApplicationPath.class).value().trim(), StandardCharsets.UTF_8);
                    if (!((String)pathValue).startsWith("/")) {
                        pathValue = "/" + (String)pathValue;
                    }
                    String prefix = pathValue;
                    pathValue = ((String)pathValue).endsWith("/") ? (String)pathValue + "*" : (String)pathValue + "/*";
                    patterns.add(pathValue);
                    this.setServletInitParam(servlet, "resteasy.servlet.mapping.prefix", prefix);
                    ServletMappingMetaData mapping = new ServletMappingMetaData();
                    mapping.setServletName(servletName);
                    mapping.setUrlPatterns(patterns);
                    if (webdata.getServletMappings() == null) {
                        webdata.setServletMappings(new ArrayList());
                    }
                    webdata.getServletMappings().add(mapping);
                    continue;
                }
                this.setServletMappingPrefix(webdata, servletName, servlet);
            }
        }
        if (!managementAdded && webdata.getServletMappings() != null) {
            for (ServletMappingMetaData servletMappingMetaData : webdata.getServletMappings()) {
                if (!JAX_RS_SERVLET_NAME.equals(servletMappingMetaData.getServletName())) continue;
                this.addManagement(deploymentUnit, resteasy);
                break;
            }
        }
        if (deploymentUnit.getParent() == null && (webdata.getServletMappings() == null || webdata.getServletMappings().isEmpty())) {
            JaxrsLogger.JAXRS_LOGGER.noServletDeclaration(deploymentUnit.getName());
        }
    }

    private void addManagement(DeploymentUnit deploymentUnit, ResteasyDeploymentData resteasy) {
        Set<String> classes = resteasy.getScannedResourceClasses();
        for (String jndiComp : resteasy.getScannedJndiComponentResources()) {
            String[] jndiCompArray = jndiComp.split(";");
            classes.add(jndiCompArray[1]);
        }
        ArrayList<String> rootRestClasses = new ArrayList<String>(classes);
        Collections.sort(rootRestClasses);
        for (String componentClass : rootRestClasses) {
            try {
                DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
                deploymentResourceSupport.getDeploymentSubModel("jaxrs", PathElement.pathElement((String)"rest-resource", (String)componentClass));
            }
            catch (Exception e) {
                JaxrsLogger.JAXRS_LOGGER.failedToRegisterManagementViewForRESTResources(componentClass, e);
            }
        }
    }

    protected void setServletInitParam(JBossServletMetaData servlet, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = servlet.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            servlet.setInitParam(params);
        }
        params.add(param);
    }

    private boolean hasJacksonAnnotations(DeploymentUnit deploymentUnit) {
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (Jackson2Annotations jackson2Annotations : Jackson2Annotations.values()) {
            if (!this.checkAnnotation(jackson2Annotations.getDotName(), index)) continue;
            return true;
        }
        for (Enum enum_ : JacksonAnnotations.values()) {
            if (!this.checkAnnotation(((JacksonAnnotations)enum_).getDotName(), index)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAnnotation(DotName name, CompositeIndex index) {
        List list = index.getAnnotations(name);
        if (list != null && !list.isEmpty()) {
            JaxrsLogger.JAXRS_LOGGER.jacksonAnnotationDetected("resteasy.preferJacksonOverJsonB");
            return true;
        }
        return false;
    }

    private void setServletMappingPrefix(JBossWebMetaData webdata, String servletName, JBossServletMetaData servlet) {
        List mappings = webdata.getServletMappings();
        if (mappings != null) {
            boolean mappingSet = false;
            for (ServletMappingMetaData mapping : mappings) {
                if (!mapping.getServletName().equals(servletName) || mapping.getUrlPatterns() == null) continue;
                for (String pattern : mapping.getUrlPatterns()) {
                    if (mappingSet) {
                        JaxrsLogger.JAXRS_LOGGER.moreThanOneServletMapping(servletName, pattern);
                        continue;
                    }
                    mappingSet = true;
                    String realPattern = pattern;
                    if (realPattern.endsWith("*")) {
                        realPattern = realPattern.substring(0, realPattern.length() - 1);
                    }
                    this.setServletInitParam(servlet, "resteasy.servlet.mapping.prefix", realPattern);
                }
            }
        }
    }

    private void addServlet(JBossWebMetaData webdata, JBossServletMetaData servlet) {
        if (webdata.getServlets() == null) {
            webdata.setServlets(new JBossServletsMetaData());
        }
        webdata.getServlets().add((MappableMetaData)servlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit context) {
        Module module = null;
        try {
            module = (Module)context.getAttachment(Attachments.MODULE);
            Class typeFactoryClass = module.getClassLoader().loadClass("com.fasterxml.jackson.databind.type.TypeFactory");
            Method defaultInstanceMethod = typeFactoryClass.getMethod("defaultInstance", new Class[0]);
            Object typeFactory = defaultInstanceMethod.invoke(null, new Object[0]);
            Method clearCache = typeFactoryClass.getDeclaredMethod("clearCache", new Class[0]);
            clearCache.invoke(typeFactory, new Object[0]);
        }
        catch (Exception e) {
            JaxrsLogger.JAXRS_LOGGER.debugf("Failed to clear class utils LRU map", new Object[0]);
        }
        finally {
            if (module != null && JaxrsDeploymentMarker.isJaxrsDeployment(context)) {
                WildFlyConfigurationFactory.getInstance().unregister((ClassLoader)module.getClassLoader());
            }
        }
    }

    public static ParamValueMetaData findContextParam(JBossWebMetaData webdata, String name) {
        List params = webdata.getContextParams();
        if (params == null) {
            return null;
        }
        for (ParamValueMetaData param : params) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public static boolean servletMappingsExist(JBossWebMetaData webdata, String servletName) {
        List mappings = webdata.getServletMappings();
        if (mappings == null) {
            return false;
        }
        for (ServletMappingMetaData mapping : mappings) {
            if (!mapping.getServletName().equals(servletName)) continue;
            return true;
        }
        return false;
    }

    public static void setContextParameter(JBossWebMetaData webdata, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = webdata.getContextParams();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            webdata.setContextParams(params);
        }
        params.add(param);
    }

    private static boolean useMicroProfileConfig(Module module, CapabilityServiceSupport support) {
        boolean configSupported = support.hasCapability("org.wildfly.microprofile.config");
        if (configSupported) {
            try {
                module.getModule("org.jboss.resteasy.microprofile.config");
                return true;
            }
            catch (ModuleLoadException moduleLoadException) {
                // empty catch block
            }
        }
        return false;
    }
}

