/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.AnnotationUsage;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ClassInfoCollector;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ClassInformation;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.JandexIndex;

public class ClassInfoScanner {
    private final ClassInfoCollector collector;
    private final TmpObjects tmpObjects = new TmpObjects();

    public ClassInfoScanner(RuntimeIndex runtimeIndex) {
        this.collector = new ClassInfoCollector(runtimeIndex);
    }

    public Set<AnnotationUsage> getUsages() {
        return this.collector.getUsages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanClass(InputStream input) throws IOException {
        BufferedInputStream in = input instanceof BufferedInputStream ? (BufferedInputStream)input : new BufferedInputStream(input);
        this.verifyMagic(in);
        boolean checkJava11AndNewer = true;
        if (!this.readVersionFields(in, checkJava11AndNewer)) {
            return;
        }
        int size = this.readUnsignedShort(in) - 1;
        byte[] constPool = null;
        try {
            constPool = this.tmpObjects.borrowConstantPool(size);
            int[] offsets = new int[size];
            int[] tags = new int[size];
            int lastOffset = 0;
            int offset = 0;
            for (int pos = 0; pos < size; ++pos) {
                int tag = this.readUnsignedByte(in);
                offsets[pos] = offset;
                tags[pos] = tag;
                switch (tag) {
                    case 7: 
                    case 8: 
                    case 16: 
                    case 19: 
                    case 20: {
                        constPool = this.sizeToFit(constPool, 2, offset, size - pos);
                        tags[pos] = tag;
                        this.readFully(in, constPool, offset, 2);
                        offset += 2;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: {
                        constPool = this.sizeToFit(constPool, 4, offset, size - pos);
                        tags[pos] = tag;
                        this.readFully(in, constPool, offset, 4);
                        offset += 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        constPool = this.sizeToFit(constPool, 8, offset, size - pos);
                        tags[pos] = tag;
                        this.readFully(in, constPool, offset, 8);
                        offset += 8;
                        ++pos;
                        break;
                    }
                    case 15: {
                        constPool = this.sizeToFit(constPool, 3, offset, size - pos);
                        tags[pos] = (byte)tag;
                        this.readFully(in, constPool, offset, 3);
                        offset += 3;
                        break;
                    }
                    case 1: {
                        int len = this.readUnsignedShort(in);
                        constPool = this.sizeToFit(constPool, len + 2, offset, size - pos);
                        tags[pos] = tag;
                        constPool[offset++] = (byte)(len >>> 8);
                        constPool[offset++] = (byte)len;
                        this.readFully(in, constPool, offset, len);
                        offset += len;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Unknown tag %s! pos = %s poolSize = %s", tag, pos, size));
                    }
                }
                lastOffset = offset;
            }
            this.skipBytes(in, 2);
            int thisClassPosition = this.readUnsignedShort(in);
            int superClassPosition = this.readUnsignedShort(in);
            int interfacesCount = this.readUnsignedShort(in);
            int[] interfacePositions = new int[interfacesCount];
            for (int i = 0; i < interfacesCount; ++i) {
                interfacePositions[i] = this.readUnsignedShort(in);
            }
            ClassInformation classInfo = new ClassInformation(tags, constPool, offsets, thisClassPosition, superClassPosition, interfacePositions, lastOffset);
            this.collector.processClass(classInfo);
        }
        finally {
            if (constPool != null) {
                this.tmpObjects.returnConstantPool(constPool);
            }
        }
    }

    public boolean checkAnnotationIndex(JandexIndex annotationIndex) {
        return this.collector.checkAnnotationIndex(annotationIndex);
    }

    private void verifyMagic(InputStream in) throws IOException {
        int magic;
        try {
            magic = this.readInteger(in);
        }
        catch (EOFException e) {
            throw new EOFException("Input is not a valid class file; must begin with a 4-byte integer 0xCAFEBABE");
        }
        if (magic != -889275714) {
            throw new IOException("Input is not a valid class file; must begin with a 4-byte integer 0xCAFEBABE, but seen 0x" + Integer.toHexString(magic).toUpperCase());
        }
    }

    private boolean readVersionFields(InputStream in, boolean checkJava11AndNewer) throws IOException {
        int minor = this.readUnsignedShort(in);
        int major = this.readUnsignedShort(in);
        if (checkJava11AndNewer) {
            return major > 45 || major == 45 && minor >= 3;
        }
        return true;
    }

    private int readInteger(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private int readUnsignedByte(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    private int readUnsignedShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new IllegalStateException();
        }
        return (ch1 << 8) + ch2;
    }

    private byte[] sizeToFit(byte[] buf, int needed, int offset, int remainingEntries) {
        int oldLength = buf.length;
        if (offset + needed > oldLength) {
            int newLength = this.newLength(oldLength, needed, oldLength >> 1);
            buf = Arrays.copyOf(buf, newLength);
        }
        return buf;
    }

    private int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        return prefLength > 0 ? prefLength : this.minLength(oldLength, minGrowth);
    }

    private int minLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Cannot allocate a large enough array: " + oldLength + " + " + minGrowth + " is too large");
        }
        return minLength;
    }

    private void readFully(InputStream in, byte[] buf, int offset, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = in.read(buf, offset + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private int skipBytes(InputStream in, int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    private static final class TmpObjects {
        private byte[] constantPool;

        private TmpObjects() {
        }

        byte[] borrowConstantPool(int poolSize) {
            byte[] buf = this.constantPool;
            if (buf == null || buf.length < 20 * poolSize) {
                buf = new byte[20 * poolSize];
            } else {
                Arrays.fill(buf, 0, poolSize, (byte)0);
            }
            this.constantPool = null;
            return buf;
        }

        void returnConstantPool(byte[] buf) {
            this.constantPool = buf;
        }
    }
}

