/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoElementAccessor;
import org.hibernate.search.mapper.pojo.model.PojoModelCompositeElement;
import org.hibernate.search.mapper.pojo.model.PojoModelProperty;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelNestedCompositeElement;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractPojoModelCompositeElement<V>
implements PojoModelCompositeElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final Map<String, PojoModelNestedCompositeElement<V, ?>> properties = new LinkedHashMap();
    private PojoTypeAdditionalMetadata typeAdditionalMetadata;
    private boolean propertiesInitialized = false;
    private PojoElementAccessor<?> accessor;

    AbstractPojoModelCompositeElement(AbstractPojoModelCompositeElement<?> parent) {
        this.introspector = parent.introspector;
        this.typeAdditionalMetadataProvider = parent.typeAdditionalMetadataProvider;
    }

    AbstractPojoModelCompositeElement(PojoBootstrapIntrospector introspector, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider) {
        this.introspector = introspector;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
    }

    @Override
    public final <T> PojoElementAccessor<T> createAccessor(Class<T> requestedType) {
        if (!this.isAssignableTo(requestedType)) {
            throw log.incompatibleRequestedType(this.getModelPathTypeNode().toUnboundPath(), requestedType);
        }
        return this.createAccessor();
    }

    @Override
    public PojoElementAccessor<?> createAccessor() {
        if (this.accessor == null) {
            this.accessor = this.doCreateAccessor();
        }
        return this.accessor;
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return this.getTypeModel().rawType().isSubTypeOf(this.introspector.typeModel(clazz));
    }

    @Override
    public Class<?> rawType() {
        return this.getTypeModel().rawType().typeIdentifier().javaClass();
    }

    @Override
    public PojoModelNestedCompositeElement<?, ?> property(String relativeFieldName) {
        return this.properties.computeIfAbsent(relativeFieldName, name -> {
            BoundPojoModelPathTypeNode<V> modelPathTypeNode = this.getModelPathTypeNode();
            PojoPropertyAdditionalMetadata additionalMetadata = this.getTypeAdditionalMetadata().getPropertyAdditionalMetadata((String)name);
            return new PojoModelNestedCompositeElement(this, modelPathTypeNode.property((String)name), additionalMetadata);
        });
    }

    @Override
    public Collection<? extends PojoModelProperty> properties() {
        if (!this.propertiesInitialized) {
            this.getTypeModel().rawType().ascendingSuperTypes().flatMap(pojoRawTypeModel -> pojoRawTypeModel.declaredProperties().stream()).map(PojoPropertyModel::name).forEach(string -> this.property((String)string));
            this.propertiesInitialized = true;
        }
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public boolean hasDependency() {
        return this.hasAccessor();
    }

    public boolean hasNonRootDependency() {
        for (PojoModelNestedCompositeElement<V, ?> property : this.properties.values()) {
            if (!property.hasAccessor()) continue;
            return true;
        }
        return false;
    }

    abstract PojoElementAccessor<V> doCreateAccessor();

    abstract BoundPojoModelPathTypeNode<V> getModelPathTypeNode();

    final boolean hasAccessor() {
        return this.accessor != null;
    }

    final void contributePropertyDependencies(PojoIndexingDependencyCollectorTypeNode<V> dependencyCollector) {
        for (Map.Entry<String, PojoModelNestedCompositeElement<V, ?>> entry : this.properties.entrySet()) {
            entry.getValue().contributeDependencies(dependencyCollector);
        }
    }

    private PojoTypeModel<V> getTypeModel() {
        return this.getModelPathTypeNode().getTypeModel();
    }

    private PojoTypeAdditionalMetadata getTypeAdditionalMetadata() {
        if (this.typeAdditionalMetadata == null) {
            this.typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(this.getModelPathTypeNode().getTypeModel().rawType());
        }
        return this.typeAdditionalMetadata;
    }
}

