/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.spi;

import java.util.Set;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public interface ConfiguredSearchIndexingPlanFilter {
    public boolean isIncluded(PojoRawTypeIdentifier<?> var1);

    default public boolean supportsAsyncProcessing() {
        return true;
    }

    public static ConfiguredSearchIndexingPlanFilter create(Set<PojoRawTypeIdentifier<?>> includes, Set<PojoRawTypeIdentifier<?>> excludes) {
        if (includes.isEmpty()) {
            return ExcludeAll.INSTANCE;
        }
        if (excludes.isEmpty()) {
            return IncludeAll.INSTANCE;
        }
        return new Filter(includes);
    }

    public static class ExcludeAll
    implements ConfiguredSearchIndexingPlanFilter {
        static final ExcludeAll INSTANCE = new ExcludeAll();

        private ExcludeAll() {
        }

        @Override
        public boolean isIncluded(PojoRawTypeIdentifier<?> typeIdentifier) {
            return false;
        }
    }

    public static class IncludeAll
    implements ConfiguredSearchIndexingPlanFilter {
        public static final IncludeAll INSTANCE = new IncludeAll();

        private IncludeAll() {
        }

        @Override
        public boolean isIncluded(PojoRawTypeIdentifier<?> typeIdentifier) {
            return true;
        }

        @Override
        public boolean supportsAsyncProcessing() {
            return false;
        }
    }

    public static class Filter
    implements ConfiguredSearchIndexingPlanFilter {
        protected final Set<PojoRawTypeIdentifier<?>> includes;

        private Filter(Set<PojoRawTypeIdentifier<?>> includes) {
            this.includes = includes;
        }

        @Override
        public boolean isIncluded(PojoRawTypeIdentifier<?> typeIdentifier) {
            return this.includes.contains(typeIdentifier);
        }

        @Override
        public boolean supportsAsyncProcessing() {
            return false;
        }
    }
}

