/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.cache.infinispan.embedded.listener.KeyFilter;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.registry.CacheContainerRegistry;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.RegistryListener;

@Listener(observation=Listener.Observation.POST)
public class CacheRegistry<K, V>
implements CacheContainerRegistry<K, V> {
    private static final Logger LOGGER = Logger.getLogger(CacheRegistry.class);
    private final Map<RegistryListener<K, V>, ExecutorService> listeners = new ConcurrentHashMap<RegistryListener<K, V>, ExecutorService>();
    private final Cache<Address, Map.Entry<K, V>> cache;
    private final Supplier<Batch> batchFactory;
    private final CacheContainerGroup group;
    private final Runnable closeTask;
    private final Map.Entry<K, V> entry;
    private final Executor executor;
    private final Function<RegistryListener<K, V>, ExecutorService> executorServiceFactory = new Function<RegistryListener<K, V>, ExecutorService>(){

        @Override
        public ExecutorService apply(RegistryListener<K, V> listener) {
            return new DefaultExecutorService((Function)ExecutorServiceFactory.SINGLE_THREAD, Thread.currentThread().getContextClassLoader());
        }
    };

    public CacheRegistry(CacheRegistryConfiguration config, Map.Entry<K, V> entry, Runnable closeTask) {
        this.cache = config.getWriteOnlyCache();
        this.batchFactory = config.getBatchFactory();
        this.group = config.getGroup();
        this.closeTask = closeTask;
        this.executor = config.getExecutor();
        this.entry = entry;
        Address localAddress = this.cache.getCacheManager().getAddress();
        try (Batch batch = this.batchFactory.get();){
            this.cache.put((Object)localAddress, this.entry);
        }
        if (!this.group.isSingleton()) {
            this.cache.addListener((Object)this, (CacheEventFilter)new KeyFilter(Address.class), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block15: {
            if (!this.group.isSingleton()) {
                this.cache.removeListener((Object)this);
            }
            Address localAddress = this.cache.getCacheManager().getAddress();
            try (Batch batch = this.batchFactory.get();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).remove((Object)localAddress);
            }
            catch (CacheException e) {
                LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                break block15;
            }
            finally {
                for (ExecutorService executor : this.listeners.values()) {
                    this.shutdown(executor);
                }
                this.listeners.clear();
                this.closeTask.run();
            }
            for (ExecutorService executor : this.listeners.values()) {
                this.shutdown(executor);
            }
            this.listeners.clear();
            this.closeTask.run();
        }
    }

    public Registration register(RegistryListener<K, V> listener) {
        if (this.group.isSingleton()) {
            return Registration.EMPTY;
        }
        this.listeners.computeIfAbsent(listener, this.executorServiceFactory);
        return () -> this.unregister(listener);
    }

    private void unregister(RegistryListener<K, V> listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    @Override
    public CacheContainerGroup getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        Set addresses = this.group.getMembership().getMembers().stream().map(GroupMember::getAddress).collect(Collectors.toUnmodifiableSet());
        HashMap result = new HashMap();
        for (Map.Entry entry : this.cache.getAdvancedCache().getAll(addresses).values()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map.Entry<K, V> getEntry(CacheContainerGroupMember member) {
        return (Map.Entry)this.cache.get((Object)member.getAddress());
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<Address, Map.Entry<K, V>> event) {
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        if (!members.equals(previousMembers)) {
            boolean restoreLocalEntry;
            AdvancedCache cache = event.getCache().getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS);
            EmbeddedCacheManager container = cache.getCacheManager();
            Address localAddress = container.getAddress();
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            if (!leftMembers.isEmpty()) {
                Locality locality = Locality.forConsistentHash((Cache)cache, (ConsistentHash)hash);
                Iterator addresses = leftMembers.iterator();
                while (addresses.hasNext()) {
                    if (locality.isLocal(addresses.next())) continue;
                    addresses.remove();
                }
            }
            boolean bl = restoreLocalEntry = !previousMembers.contains(localAddress);
            if (!leftMembers.isEmpty() || restoreLocalEntry) {
                try {
                    this.executor.execute(() -> this.lambda$topologyChanged$1(leftMembers, (Cache)cache, restoreLocalEntry, localAddress));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> event(CacheEntryEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (!event.isOriginLocal() && (entry = (Map.Entry)event.getValue()) != null) {
            this.executor.execute(() -> this.notifyListeners(event.getType(), entry));
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryRemoved
    public CompletionStage<Void> removed(CacheEntryRemovedEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (!event.isOriginLocal() && (entry = (Map.Entry)event.getOldValue()) != null) {
            this.executor.execute(() -> this.notifyListeners(event.getType(), entry));
        }
        return CompletableFuture.completedStage(null);
    }

    private void notifyListeners(Event.Type type, Map.Entry<K, V> entry) {
        this.notifyListeners(type, Collections.singletonMap(entry.getKey(), entry.getValue()));
    }

    private void notifyListeners(Event.Type type, Map<K, V> entries) {
        for (Map.Entry<RegistryListener<K, V>, ExecutorService> entry : this.listeners.entrySet()) {
            RegistryListener listener = entry.getKey();
            Executor executor = entry.getValue();
            try {
                executor.execute(() -> {
                    try {
                        switch (type) {
                            case CACHE_ENTRY_CREATED: {
                                listener.added(entries);
                                break;
                            }
                            case CACHE_ENTRY_MODIFIED: {
                                listener.updated(entries);
                                break;
                            }
                            case CACHE_ENTRY_REMOVED: {
                                listener.removed(entries);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(type.name());
                            }
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn((Object)e.getLocalizedMessage(), e);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void shutdown(ExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private /* synthetic */ void lambda$topologyChanged$1(Set leftMembers, Cache cache, boolean restoreLocalEntry, Address localAddress) {
        if (!leftMembers.isEmpty()) {
            HashMap removed = new HashMap();
            try {
                for (Address leftMember : leftMembers) {
                    Map.Entry old = (Map.Entry)cache.remove((Object)leftMember);
                    if (old == null) continue;
                    removed.put(old.getKey(), old.getValue());
                }
            }
            catch (CacheException e) {
                LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (!removed.isEmpty()) {
                this.notifyListeners(Event.Type.CACHE_ENTRY_REMOVED, removed);
            }
        }
        if (restoreLocalEntry) {
            try {
                if (cache.put((Object)localAddress, this.entry) == null) {
                    this.notifyListeners(Event.Type.CACHE_ENTRY_CREATED, this.entry);
                }
            }
            catch (CacheException e) {
                LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

