/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import jakarta.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.serialization.AbstractSerializableHolder;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;

public class BeanHolder<T>
extends AbstractSerializableHolder<Bean<T>> {
    private static final long serialVersionUID = 6039992808930111222L;
    private final String contextId;
    private final BeanIdentifier beanId;

    public static <T> BeanHolder<T> of(String contextId, Bean<T> bean) {
        return new BeanHolder<T>(contextId, bean);
    }

    public BeanHolder(String contextId, Bean<T> bean) {
        super(bean);
        this.contextId = contextId;
        this.beanId = bean == null ? null : ((ContextualStore)Container.instance(contextId).services().get(ContextualStore.class)).putIfAbsent(bean);
    }

    @Override
    protected Bean<T> initialize() {
        if (this.beanId == null) {
            return null;
        }
        return (Bean)((ContextualStore)Container.instance(this.contextId).services().get(ContextualStore.class)).getContextual(this.beanId);
    }
}

