/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import org.jboss.ws.common.Messages;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.common.utils.UrlPatternUtils;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class URLPatternDeploymentAspect
extends AbstractDeploymentAspect {
    @Override
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            HttpEndpoint httpEp;
            String urlPattern;
            if (!(ep instanceof HttpEndpoint) || (urlPattern = (httpEp = (HttpEndpoint)ep).getURLPattern()) != null) continue;
            urlPattern = this.getExplicitPattern(dep, ep);
            if (urlPattern == null) {
                urlPattern = ep.getShortName();
            }
            httpEp.setURLPattern(UrlPatternUtils.getUrlPattern(urlPattern));
        }
    }

    protected String getExplicitPattern(Deployment dep, Endpoint ep) {
        EJBArchiveMetaData appMetaData;
        String urlPattern = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null && WSHelper.isJseEndpoint(ep)) {
            String epName = ep.getShortName();
            urlPattern = (String)webMetaData.getServletMappings().get(epName);
            if (urlPattern == null) {
                throw Messages.MESSAGES.cannotObtainServletMapping(epName);
            }
        }
        if ((appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null && appMetaData.getBeanByEjbName(ep.getShortName()) != null && WSHelper.isEjbEndpoint(ep)) {
            EJBMetaData bmd = appMetaData.getBeanByEjbName(ep.getShortName());
            urlPattern = UrlPatternUtils.getUrlPatternByPortComponentURI(bmd.getPortComponentURI(), dep.getService().getContextRoot());
        }
        if (urlPattern == null) {
            urlPattern = UrlPatternUtils.getUrlPatternByWebContext(ep.getTargetBeanClass());
        }
        if (urlPattern == null) {
            urlPattern = UrlPatternUtils.getUrlPatternByWebService(ep.getTargetBeanClass());
        }
        if (urlPattern == null) {
            urlPattern = UrlPatternUtils.getUrlPatternByClassname(ep.getTargetBeanClass());
        }
        return urlPattern;
    }
}

