/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class AddClientListenerOperation
extends ClientListenerOperation {
    private final byte[][] filterFactoryParams;
    private final byte[][] converterFactoryParams;

    protected AddClientListenerOperation(InternalRemoteCache<?, ?> remoteCache, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super(remoteCache, listener);
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
    }

    private AddClientListenerOperation(InternalRemoteCache<?, ?> remoteCache, Object listener, byte[] listenerId, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        super(remoteCache, listener, listenerId);
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
    }

    @Override
    public ClientListenerOperation copy() {
        return new AddClientListenerOperation(this.internalRemoteCache, this.listener, this.listenerId, this.filterFactoryParams, this.converterFactoryParams);
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        ClientListener clientListener = this.extractClientListener();
        ByteBufUtil.writeArray(buf, this.listenerId);
        codec.writeClientListenerParams(buf, clientListener, this.filterFactoryParams, this.converterFactoryParams);
        codec.writeClientListenerInterests(buf, ClientEventDispatcher.findMethods(this.listener).keySet());
    }

    @Override
    public Channel createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (HotRodConstants.isSuccess(status)) {
            return decoder.getChannel();
        }
        return null;
    }

    @Override
    public short requestOpCode() {
        return 37;
    }

    @Override
    public short responseOpCode() {
        return 38;
    }
}

