/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.handler.codec.DecoderException;
import java.nio.charset.StandardCharsets;
import org.infinispan.client.hotrod.impl.operations.NoCachePingOperation;
import org.infinispan.client.hotrod.impl.operations.PingResponse;

public class CachePingOperation
extends NoCachePingOperation {
    private final String cacheName;

    public CachePingOperation(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public short requestOpCode() {
        return 23;
    }

    @Override
    public short responseOpCode() {
        return 24;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public byte[] getCacheNameBytes() {
        return this.cacheName.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public boolean completeExceptionally(Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
            return false;
        }
        return super.completeExceptionally(cause);
    }
}

